/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.autoclicker;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import it.unimi.dsi.fastutil.Pair;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1819;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.mikey.autoclicker.Config;
import pro.mikey.autoclicker.Holding;
import pro.mikey.autoclicker.Language;
import pro.mikey.autoclicker.OptionsScreen;

public class AutoClicker {
    public static final String MOD_ID = "autoclicker";
    public static final Logger LOGGER = LogManager.getLogger((String)"autoclicker");
    private static final class_304.class_11900 KEYBIND_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"autoclicker", (String)"keybinding-title"));
    public static final class_304 openConfig = new class_304("keybinding.open-gui", 79, KEYBIND_CATEGORY);
    public static final class_304 toggleHolding = new class_304("keybinding.toggle-hold", 73, KEYBIND_CATEGORY);
    private static final Supplier<Pair<Path, Path>> CONFIG_PATHS = Suppliers.memoize(() -> {
        Path configDir = Paths.get(class_310.method_1551().field_1697.getPath() + "/config", new String[0]);
        Path configFile = Paths.get(String.valueOf(configDir) + "/auto-clicker-fabric.json", new String[0]);
        return Pair.of((Object)configDir, (Object)configFile);
    });
    public static Holding.AttackHolding leftHolding;
    public static Holding rightHolding;
    public static Holding jumpHolding;
    public static Config.HudConfig hudConfig;
    private static AutoClicker INSTANCE;
    private boolean isActive = false;
    private Config config = new Config(new Config.LeftMouseConfig(false, false, 0, false, false, false), new Config.RightMouseConfig(false, false, 0), new Config.JumpConfig(false, false, 0), new Config.HudConfig(true, "top-left"));

    public AutoClicker() {
        INSTANCE = this;
    }

    public static AutoClicker getInstance() {
        return INSTANCE;
    }

    public void onInitialize() {
        LOGGER.info("Auto Clicker Initialised");
    }

    public void clientReady(class_310 client) {
        Pair<Path, Path> configPaths = CONFIG_PATHS.get();
        if (!Files.exists((Path)configPaths.value(), new LinkOption[0])) {
            try {
                Files.createDirectories((Path)configPaths.key(), new FileAttribute[0]);
                Files.createFile((Path)configPaths.value(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.saveConfig();
        } else {
            try {
                FileReader json = new FileReader(((Path)configPaths.value()).toFile());
                Config config = (Config)new Gson().fromJson((Reader)json, Config.class);
                json.close();
                if (config != null && config.getHudConfig() != null) {
                    this.config = config;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.saveConfig();
            }
        }
        leftHolding = new Holding.AttackHolding(client.field_1690.field_1886, this.config.getLeftClick());
        rightHolding = new Holding(client.field_1690.field_1904, this.config.getRightClick());
        jumpHolding = new Holding(client.field_1690.field_1903, this.config.getJump());
        hudConfig = this.config.getHudConfig();
    }

    public void saveConfig() {
        Pair<Path, Path> configPaths = CONFIG_PATHS.get();
        try {
            FileWriter writer = new FileWriter(((Path)configPaths.value()).toFile());
            new Gson().toJson((Object)this.config, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void renderGameOverlayEvent(class_332 context, class_9779 delta) {
        int x;
        int y;
        class_2561 text;
        if (!((leftHolding.isActive() || rightHolding.isActive() || jumpHolding.isActive()) && this.isActive && this.config.getHudConfig().isEnabled())) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (leftHolding.isActive()) {
            text = Language.HUD_HOLDING.getText(class_1074.method_4662((String)leftHolding.getKey().method_1431(), (Object[])new Object[0]));
            y = this.getHudY() + 0;
            x = this.getHudX(text);
            context.method_35720(client.field_1772, text.method_30937(), x, y, -1);
        }
        if (rightHolding.isActive()) {
            text = Language.HUD_HOLDING.getText(class_1074.method_4662((String)rightHolding.getKey().method_1431(), (Object[])new Object[0]));
            y = this.getHudY() + 15;
            x = this.getHudX(text);
            context.method_35720(client.field_1772, text.method_30937(), x, y, -1);
        }
        if (jumpHolding.isActive()) {
            text = Language.HUD_HOLDING.getText(class_1074.method_4662((String)jumpHolding.getKey().method_1431(), (Object[])new Object[0]));
            y = this.getHudY() + 30;
            x = this.getHudX(text);
            context.method_35720(client.field_1772, text.method_30937(), x, y, -1);
        }
    }

    public int getHudX(class_2561 text) {
        String location;
        class_310 client = class_310.method_1551();
        return switch (location = this.config.getHudConfig().getLocation()) {
            case "top-left", "bottom-left" -> 10;
            case "top-right", "bottom-right" -> class_310.method_1551().method_22683().method_4486() - 10 - client.field_1772.method_27525((class_5348)text);
            default -> 10;
        };
    }

    public int getHudY() {
        String location;
        return switch (location = this.config.getHudConfig().getLocation()) {
            case "top-left", "top-right" -> 10;
            case "bottom-left", "bottom-right" -> class_310.method_1551().method_22683().method_4502() - 50;
            default -> 10;
        };
    }

    public void clientTickEvent(class_310 mc) {
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        if (!mc.field_1724.method_5805()) {
            this.isActive = false;
        }
        if (this.isActive) {
            if (leftHolding.isActive()) {
                this.handleActiveHolding(mc, leftHolding);
            }
            if (rightHolding.isActive()) {
                this.handleActiveHolding(mc, rightHolding);
            }
            if (jumpHolding.isActive()) {
                this.handleActiveHolding(mc, jumpHolding);
            }
        }
        this.keyInputEvent(mc);
    }

    private void handleActiveHolding(class_310 mc, Holding key) {
        assert (mc.field_1724 != null);
        if (!key.isActive()) {
            return;
        }
        if (key.isSpamming()) {
            if (key.getSpeed() > 0) {
                if (key.getTimeout() <= 1) {
                    if (key.getTimeout() <= 0) {
                        key.resetTimeout();
                    }
                    key.getKey().method_23481(key.getTimeout() == 1);
                    if (key.getKey().method_1434()) {
                        this.attemptMobAttack(mc, key);
                    }
                }
                key.decreaseTimeout();
            } else {
                key.getKey().method_23481(!key.getKey().method_1434());
                if (key.getKey().method_1434()) {
                    this.attemptMobAttack(mc, key);
                }
            }
            return;
        }
        if (key.isRespectCooldown()) {
            if (key instanceof Holding.AttackHolding && ((Holding.AttackHolding)key).isMobMode() && !this.isPlayerLookingAtMob(mc)) {
                if (key.getKey().method_1434()) {
                    key.getKey().method_23481(false);
                }
                return;
            }
            if (mc.field_1724.method_7261(0.0f) == 1.0f) {
                key.getKey().method_23481(true);
                this.attemptMobAttack(mc, key);
            } else {
                key.getKey().method_23481(false);
            }
        } else {
            key.getKey().method_23481(true);
        }
    }

    private void attemptMobAttack(class_310 mc, Holding key) {
        if (key.getKey() != leftHolding.getKey()) {
            return;
        }
        class_239 rayTrace = mc.field_1765;
        if (!(!(rayTrace instanceof class_3966) || mc.field_1761 == null || this.config.getLeftClick().isRespectShield() && this.isShielding(mc.field_1724))) {
            mc.field_1761.method_2918((class_1657)mc.field_1724, ((class_3966)rayTrace).method_17782());
            if (mc.field_1724 != null) {
                mc.field_1724.method_6104(class_1268.field_5808);
            }
        }
    }

    private boolean isShielding(class_746 player) {
        if (player.method_6115()) {
            return player.method_6030().method_7909() instanceof class_1819;
        }
        return false;
    }

    private boolean isPlayerLookingAtMob(class_310 mc) {
        class_1309 livingEntity;
        class_1297 class_12972;
        class_239 rayTrace = mc.field_1765;
        return rayTrace instanceof class_3966 && (class_12972 = ((class_3966)rayTrace).method_17782()) instanceof class_1309 && (livingEntity = (class_1309)class_12972).method_5805() && livingEntity.method_5732();
    }

    private void keyInputEvent(class_310 mc) {
        assert (mc.field_1724 != null);
        while (toggleHolding.method_1436()) {
            this.isActive = !this.isActive;
            mc.field_1724.method_7353((class_2561)(this.isActive ? Language.MSG_HOLDING_KEYS : Language.MSG_RELEASED_KEYS).getText().method_27692(this.isActive ? class_124.field_1060 : class_124.field_1061), true);
            if (this.isActive) continue;
            if (leftHolding.isActive()) {
                leftHolding.getKey().method_23481(false);
            }
            if (rightHolding.isActive()) {
                rightHolding.getKey().method_23481(false);
            }
            if (!jumpHolding.isActive()) continue;
            jumpHolding.getKey().method_23481(false);
        }
        while (openConfig.method_1436()) {
            mc.method_1507((class_437)this.getConfigScreen());
        }
    }

    public OptionsScreen getConfigScreen() {
        return new OptionsScreen();
    }
}

