/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick;

import fr.maxlego08.autoclick.api.result.AnalyzeResult;
import fr.maxlego08.autoclick.api.utils.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClickAnalyzer {
    public static AnalyzeResult analyzeSession(List<Integer> clicks) {
        if (clicks == null || clicks.size() < 10) {
            return AnalyzeResult.empty();
        }
        ArrayList<Integer> sorted = new ArrayList<Integer>(clicks);
        sorted.sort(Comparator.naturalOrder());
        int removeCount = (int)((double)sorted.size() * Config.sessionTrimmed);
        if (removeCount * 2 >= sorted.size()) {
            return AnalyzeResult.empty();
        }
        List cleaned = sorted.subList(removeCount, sorted.size() - removeCount);
        double mean = cleaned.stream().mapToDouble(a -> a.intValue()).average().orElse(0.0);
        double variance = cleaned.stream().mapToDouble(a -> Math.pow((double)a.intValue() - mean, 2.0)).sum() / (double)cleaned.size();
        double stdDev = Math.sqrt(variance);
        int min = (Integer)Collections.min(cleaned);
        int max = (Integer)Collections.max(cleaned);
        int range = max - min;
        int smallVariations = 0;
        int largeJumpDetected = 0;
        int last = (Integer)cleaned.getFirst();
        for (int i = 1; i < cleaned.size(); ++i) {
            int diff = Math.abs((Integer)cleaned.get(i) - last);
            if (diff < Config.smallVariation) {
                ++smallVariations;
            }
            if (diff > Config.largeVariation) {
                ++largeJumpDetected;
            }
            last = (Integer)cleaned.get(i);
        }
        double smallVariationPercent = (double)smallVariations * 100.0 / (double)(cleaned.size() - 1);
        HashMap<Integer, Integer> frequencyMap = new HashMap<Integer, Integer>();
        Iterator iterator = cleaned.iterator();
        while (iterator.hasNext()) {
            int click = (Integer)iterator.next();
            frequencyMap.put(click, frequencyMap.getOrDefault(click, 0) + 1);
        }
        ArrayList topFrequencies = new ArrayList(frequencyMap.entrySet());
        topFrequencies.sort((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue()));
        double top1Percentage = (double)((Integer)((Map.Entry)topFrequencies.getFirst()).getValue()).intValue() * 100.0 / (double)cleaned.size();
        double top3Percentage = (double)topFrequencies.stream().limit(3L).mapToInt(Map.Entry::getValue).sum() * 100.0 / (double)cleaned.size();
        double score = 0.0;
        if (smallVariationPercent > Config.smallVariationThresholdPercent) {
            score += (smallVariationPercent - Config.smallVariationThresholdPercent) * Config.smallVariationMultiplier;
        }
        if ((double)range < mean * Config.rangeRelativeThreshold) {
            score += (1.0 - (double)range / (mean * Config.rangeRelativeThreshold)) * Config.rangeMaxBonus;
        }
        if (stdDev < mean * Config.stddevRelativeThreshold) {
            score += (1.0 - stdDev / (mean * Config.stddevRelativeThreshold)) * Config.stddevMaxBonus;
        }
        if (top1Percentage > Config.top1FrequencyThresholdPercent) {
            score += (top1Percentage - Config.top1FrequencyThresholdPercent) * Config.top1FrequencyMultiplier;
        }
        if (top3Percentage > Config.top3FrequencyThresholdPercent) {
            score += (top3Percentage - Config.top3FrequencyThresholdPercent) * Config.top3FrequencyMultiplier;
        }
        if (largeJumpDetected == 0) {
            score += Config.noLargeJumpBonus;
        }
        return new AnalyzeResult((score = Math.min(score, Config.maxScore)) >= Config.score, score);
    }

    public static void main(String[] args) {
        String session1 = "703,640,703,604,704,637,669,671,672,704,635,704,605,702,635,671,634,708,637,669,637,639,672,637,637,671,638,674,638,704,604,703,635,636,703,672,640,705,638,669,637,703,604,703,704,638,638,671,639,640,672,671,670,638,671,640,704,637,672,639,706,636,703,638,603,670,639,640,673,673,671,637,638,672,637,674,639,706,638,637,673,702,603,672,674,704,638,636,670,637,670,637,705,606,672,670,603,705,637,606,702,604,636,707,636,671,670,670,636,670,705,636,637,672,637,707,707,602,675,672,704,637,704,607,704,639,638,671,639,639,670,636,704,637,671,637,705,637,670,640,635,671,638,672,671,671,605,672,703,670,636,670,670,668,705,605,637,636,669,705,600,704,637,637,670,704,612,663,672,703,638,700,637,673,705,638,703,603,604,672,703,672,604,637,636,669,704,636,705,640,673,640,639,672,635,705,634,672,637,704,637,670,637,706,603,706,604,638,637,674,638,704,639,670,672,672,636,706,641,672,639,640,670,637,703,638,670,673,670,703,637,670,637,703,636,673,670,670,640,671,636,704,606,671,670,703,638,671,639,703,637,671,638,706,641,673,664,670,640,638,670,637,670,638,704,603,704,638,639,676,669,672,638,642,670,703,636,670,671,669,637,669,634,705,604,637,710,603,636,669,639,707,602,704,636,639,671,706,637,638,671,673,674,640,704,641,666,638,705,636,671,637,670,669,671,703,640,702,604,705,638,638,672,704,603,669,671,705,637,638,671,636,673,637,705,603,704,638,638,673,670,669,705,642,640,670,706,635,636,673,639,642,671,639,637,668,638,671,672,672,639,703,640,671,637,638,671,703,638,706,603,634,670,638,636,670,702,605,670,671,703,640,703,605,703,636,705,602,705,639,705,606,703,638,702,636,671,637,670,702,639,703,603,703,637,603,705,637,704,604,705,648,599,703,604,640,703,635,672,639,706,604,671,669,634,671,637,670,674,670,643,636,672,704,634,636,674,701,637,669,636,701,639,671,703,637,703,603,705,637,705,603,704,636,705,637,672,636,639,671";
        String session2 = "569,602,570,604,572,605,605,605,537,571,603,603,537,604,605,538,603,603,604,538,570,569,571,536,571,539,605,537,571,536,602,537,569,503,606,536,606,539,602,538,603,603,604,538,602,570,538,569,538,605,503,536,602,537,571,602,604,537,601,602,536,606,603,605,604,536,570,536,603,538,570,637,603,605,534,571,603,570,570,605,538,568,570,574,603,535,604,503,537,569,602,535,536,568,503,504,537,569,535,503,536,570,506,571,568,537,571,535,605,536,571,537,571,534,537,569,534,573,571,572,601,538,567,502,535,601,502,536,570,503,601,538,503,503,502,536,569,535,502,537,570,537,569,536,605,535,571,571,570,538,570,605,639,571,570,507,567,604,536,538,569,503,539,604,567,539,606,536,570,605,533,573,536,501,538,571,538,536,503,503,570,537,535,535,569,603,502,504,537,502,504,537,503,503,503,504,505,570,570,537,571,501,571,503,538,504,535,572,502,540,502,536,570,506,536,536,570,535,570,536,540,567,535,569,536,571,536,605,538,539,501,603,502,570,534,572,537,537,569,603,539,604,603,503,537,538,568,537,570,538,537,502,570,602,603,538,537,605,671,1725,532,562,570,536,570,501,603,537,539,569,536,603,607,637,502,570,540,605,536,571,535,605,536,572,570,570,601,604,503,501,534,538,571,503,534,504,603,536,501,504,503,571,538,602,537,572,537,602,537,571,1101,534,501,502,604,504,536,568,502,569,571,602,503,502,605,570,537,571,501,571,571,503,604,537,534,604,569,535,568,502,535,504,536,569,857,601,569,537,540,564,501,602,536,569,537,767,602,536,540,569,536,568,604,538,540,601,569,539,606,502,603,503,535,663,605,534,570,537,536,571,535,505,537,504,503,571,607,535,570,501,503,535,501,505,543,604,510,529,506,537,537,603,572,574,569,537,570,536,501,536,571,535,605,538,569,503,503,504,536,506,502,503,538,502,536,504,570,536,536,758,504,503,505,505,603,503,535,503,503,536,505,537,570,569,535,504,535,535";
        String session3 = "704,604,705,637,638,671,705,604,669,670,707,640,604,637,668,673,670,635,671,704,638,641,670,641,705,604,671,670,705,605,672,668,603,705,603,668,670,638,668,604,672,670,606,670,672,706,636,638,670,637,671,635,705,637,672,637,703,602,704,637,670,638,706,639,638,672,637,670,638,640,707,636,673,702,603,671,671,704,605,671,673,605,673,669,638,668,672,671,706,639,602,635,672,604,672,670,636,669,640,636,671,638,705,641,670,602,671,670,637,669,704,637,641,666,638,706,637,671,640,703,636,670,603,668,670,705,638,670,639,703,639,705,638,670,636,707,639,670,671,675,635,670,638,636,671,605,639,707,635,672,636,704,640,707,640,672,638,636,671,637,705,604,701,637,639,670,704,604,635,669,670,674,639,639,671,638,704,640,673,672,670,636,673,637,702,636,670,636,706,637,670,705,637,605,705,604,670,671,637,671,636,705,638,669,641,638,671,670,672,635,672,637,704,604,703,637,703,639,672,674,673,638,637,672,636,670,635,705,637,670,637,671,638,703,605,670,670,603,704,606,671,671,637,705,635,673,639,636,671,604,704,603,671,670,640,637,674,637,671,636,705,638,669,638,639,670,637,707,603,706,636,706,604,704,637,602,636,670,637,705,605,639,638,671,638,672,637,635,669,636,670,639,704,605,705,639,604,706,639,706,638,638,672,606,670,669,638,670,634,670,636,703,636,670,639,637,671,603,702,635,668,671,669,636,671,636,641,671,639,701,604,637,671,636,702,637,673,674,671,640,639,671,605,637,705,704,604,705,637,635,671,703,637,704,601,704,636,670,639,637,670,604,670,670,637,671,637,707,604,705,636,636,673,605,669,671,704,605,669,673,638,669,635,702,603,703,605,702,637,637,671,706,640,706,639,638,672,704,635,637,702,672,604,670,671,634,671,636,669,634,705,635,671,637,704,638,643,672,636,669,704,637,636,671,604,671,672,638,671,674,673,602,739,636,669,608,637,704,704,637,604,706,637,671,669,671,704,642,638,671,641,637,672,637,703,639,670,638,701,634,668,703";
        String session4 = "1005,1140,1003,1107,1038,1004,1040,1040,1073,1039,1006,1041,1039,1006,1071,1039,1006,1106,1038,1008,1039,1038,1075,1143,1005,1072,1111,1173,973,1075,1141,1007,1001,1039,1040,1073,1037,1003,1109,1040,1106,1040,1007,1038,1038,1073,1007,1039,1039,1041,1071,1006,1040,1041,1005,1040,1077,1040,1005,1004,1142,1005,1045,1003,1042,1107,1040,1007,1105,1105,1035,1037,1075,1072,1072,1009,1038,1044,1039,1009,1109,1042,1007,1141,1109,1042,1108,1107,1075,1074,1004,1142,1007,1042,1107,1042,1105,1040,1039,1011,1040,1074,1042,1106,1041,1009,1075,1076,1042,1107,1003,1141,1005,1077,1068,1007,1039,1109,1043,1105,1074,1071,1006,1040,1038,1070,1006,1040,1009,1140,1006,1077,1074,1070,1109,1072,1140,1006,1106,1037,1006,1143,1006,1107,1039,1007,1034,1110,1041,1105,1107,1105,1041,1004,1006,1042,1009,1043,1193,952,1006,1040,1042,1077,1074,1041,1105,1111,1006,1109,1044,1142,1007,1107,1141,1109,1041,1039,1038,1109,1044,1071,1040,1041,1009,1040,1107,1104,1011,1041,1106,1006,1139,1006,1038,1111,1003,1038,1038,1073,1074,1175,1005,1072,1107,1107,1007,1039,1040,1072,1105,976,1074,1042,1107,1142,1007,1003,1037,1043,1067,1039,1005,1008,1041,1038,1071,1038,1008,1004,1139,1105,1042,1106,1104,1140,1006,1006,1071,1107,1108,1007,1040,1109,1106,1038,1109,1001,1105,1042,1007,1037,1042,1072,1074,1103,1107,1039,1073,1040,1009,1041,1039,1009,1038,1075,1076,1072,974,1070,1006,1074,1074,1075,1074,1009,1036,1001,1039,1106,1042,1105,1039,1074";
        ClickAnalyzer.look("Session 1", session1);
        ClickAnalyzer.look("Session 2", session2);
        ClickAnalyzer.look("Session 3", session3);
        ClickAnalyzer.look("Session 4", session4);
    }

    public static void look(String session, String raw) {
        System.out.println("\n=== Conclusion " + session + " ===");
        AnalyzeResult result = ClickAnalyzer.analyzeSession(ClickAnalyzer.parse(raw));
        if (result.isCheat()) {
            System.out.println("\u274c Session suspecte : comportement artificiel d\u00e9tect\u00e9.");
        } else {
            System.out.println("\u2705 Session naturelle : comportement humain d\u00e9tect\u00e9.");
        }
        System.out.println();
    }

    public static List<Integer> parse(String rawData) {
        String[] split = rawData.split(",");
        ArrayList<Integer> clicks = new ArrayList<Integer>();
        for (String s : split) {
            clicks.add(Integer.parseInt(s.trim()));
        }
        return clicks;
    }
}

