/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick;

import fr.maxlego08.autoclick.ClickAnalyzer;
import fr.maxlego08.autoclick.Session;
import fr.maxlego08.autoclick.ZClickPlugin;
import fr.maxlego08.autoclick.api.ClickSession;
import fr.maxlego08.autoclick.api.result.AnalyzeResult;
import fr.maxlego08.autoclick.api.result.SessionResult;
import fr.maxlego08.autoclick.api.storage.dto.InvalidSessionDTO;
import fr.maxlego08.autoclick.api.storage.dto.SessionDTO;
import fr.maxlego08.autoclick.api.utils.Config;
import fr.maxlego08.autoclick.storage.StorageManager;
import fr.maxlego08.autoclick.zcore.enums.Message;
import fr.maxlego08.autoclick.zcore.utils.ZUtils;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class SessionManager
extends ZUtils
implements Listener {
    private final ZClickPlugin plugin;
    private final ConcurrentMap<UUID, Session> sessions = new ConcurrentHashMap<UUID, Session>();

    public SessionManager(ZClickPlugin plugin) {
        this.plugin = plugin;
    }

    public void onClick(UUID uuid) {
        BukkitTask task;
        int difference;
        long now = System.currentTimeMillis();
        Session session = this.sessions.computeIfAbsent(uuid, k -> new Session(uuid, now));
        if (session.getLastClickAt() != 0L && (difference = (int)((long)((int)now) - session.getLastClickAt())) >= Config.minimumDelay) {
            session.addDifferences(difference);
        }
        if ((task = session.getTask()) != null) {
            task.cancel();
        }
        BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
        session.setTask(scheduler.runTaskLater((Plugin)this.plugin, () -> this.endSession(uuid, session), (long)Config.sessionEndAfter));
        session.setLastClickAt(now);
    }

    private void endSession(UUID uuid, Session session) {
        BukkitTask task;
        Player player = Bukkit.getPlayer((UUID)uuid);
        session.setFinishedAt(System.currentTimeMillis());
        this.sessions.remove(uuid);
        StorageManager storage = this.plugin.getStorageManager();
        if (session.isValid()) {
            storage.insertSession(uuid, session, id -> {
                session.setId((Integer)id);
                this.plugin.getLogger().info(String.valueOf(uuid) + " vient de terminer une session de " + session.count() + " cliques. Dur\u00e9e: " + session.getDuration() / 1000L + "s.");
                BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
                scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
                    AnalyzeResult analyzeResult = ClickAnalyzer.analyzeSession(session.getDifferences());
                    if (analyzeResult.isCheat()) {
                        SessionResult sessionResult = this.verifySession(session);
                        this.plugin.getLogger().info("La session de " + String.valueOf(uuid) + " (id: " + session.getId() + ") est consid\u00e9r\u00e9 comme une session d'auto-click.");
                        storage.insertInvalidSession(session, sessionResult, analyzeResult, invalidSession -> {
                            session.setInvalidSession((InvalidSessionDTO)invalidSession);
                            this.sendActions(Config.endCheatSessionActions, player, session);
                        });
                    } else {
                        this.sendActions(Config.endSessionActions, player, session);
                    }
                });
            });
        }
        if ((task = session.getTask()) != null) {
            task.cancel();
        }
        session.setTask(null);
    }

    private SessionResult verifySession(ClickSession session) {
        List<Integer> intervals = session.getDifferences();
        ArrayList<Integer> sorted = new ArrayList<Integer>(intervals);
        Collections.sort(sorted);
        int size = sorted.size();
        int removeCount = (int)((double)size * Config.sessionTrimmed);
        List<Integer> trimmed = sorted.subList(removeCount, size - removeCount);
        double average = trimmed.stream().mapToInt(Integer::intValue).average().orElse(0.0);
        double variance = trimmed.stream().mapToDouble(i -> Math.pow((double)i.intValue() - average, 2.0)).average().orElse(0.0);
        double standardDeviation = Math.sqrt(variance);
        double median = this.calculateMedian(trimmed);
        return new SessionResult(average, median, standardDeviation);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (this.sessions.containsKey(uuid)) {
            this.endSession(uuid, (Session)this.sessions.get(uuid));
        }
    }

    public void information(CommandSender sender, ClickSession session, boolean sendIfClean) {
        long duration = session.getDuration();
        List<Integer> intervals = session.getDifferences();
        SessionResult sessionResult = this.verifySession(session);
        double average = sessionResult.average();
        double median = sessionResult.median();
        double standardDeviation = sessionResult.standardDeviation();
        if (standardDeviation >= Config.standardDeviation && !sendIfClean) {
            return;
        }
        DecimalFormat format = new DecimalFormat("#.##");
        long hours = duration / 3600000L;
        long minutes = duration % 3600000L / 60000L;
        long seconds = duration % 60000L / 1000L;
        AnalyzeResult result = ClickAnalyzer.analyzeSession(intervals);
        double percents = result.percent();
        this.message(sender, Message.SESSION_INFORMATION, "%uuid%", session.getUniqueId().toString(), "%id%", session.getId(), "%average%", format.format(average), "%median%", format.format(median), "%color%", standardDeviation < 10.0 ? "\u00a74" : (standardDeviation < 20.0 ? "\u00a74" : (standardDeviation < 30.0 ? "\u00a76" : (standardDeviation < 40.0 ? "\u00a7e" : "\u00a7a"))), "%standard-deviation%", format.format(standardDeviation), "%duration%", String.format("%02d:%02d:%02d", hours, minutes, seconds), "%percent%", format.format(percents), "%color-percent%", percents >= 90.0 ? "\u00a74" : (percents >= 80.0 ? "\u00a7c" : (percents >= 70.0 ? "\u00a76" : (percents >= 60.0 ? "\u00a7e" : "\u00a7a"))), "%cheat%", result.isCheat() ? "Oui" : "Non", "%color-cheat%", result.isCheat() ? "\u00a72" : "\u00a74");
    }

    public void showAll(CommandSender sender) {
        this.plugin.getStorageManager().select(sessions -> sessions.forEach(e -> this.information(sender, (ClickSession)e, true)));
    }

    public void sendSuspect(CommandSender sender, long seconds, boolean sendIfClean) {
        this.plugin.getStorageManager().select(sessions -> {
            for (SessionDTO session : sessions) {
                if (session.getDuration() < seconds * 1000L) continue;
                this.information(sender, session, sendIfClean);
            }
        });
    }

    private double calculateMedian(List<Integer> data) {
        ArrayList<Integer> sorted = new ArrayList<Integer>(data);
        Collections.sort(sorted);
        int middle = sorted.size() / 2;
        if (sorted.size() % 2 == 0) {
            return (double)((Integer)sorted.get(middle - 1) + (Integer)sorted.get(middle)) / 2.0;
        }
        return ((Integer)sorted.get(middle)).intValue();
    }

    private void sendActions(List<Action> actions, Player player, ClickSession session) {
        InventoryEngine fakeInventory = this.plugin.getInventoryManager().getFakeInventory();
        Placeholders placeholders = this.createPlaceholders(session);
        List<ClickSession> sessions = this.plugin.getStorageManager().getSessions(player.getUniqueId());
        placeholders.register("sessions", String.valueOf(sessions.size()));
        placeholders.register("s", sessions.size() == 1 ? "" : "s");
        placeholders.register("invalid-sessions", String.valueOf(sessions.stream().filter(ClickSession::isCheat).count()));
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            for (Action action : actions) {
                action.preExecute(player, null, fakeInventory, placeholders);
            }
        });
    }

    public Placeholders createPlaceholders(ClickSession session) {
        DecimalFormat format = new DecimalFormat("#.##");
        long duration = session.getDuration();
        long hours = duration / 3600000L;
        long minutes = duration % 3600000L / 60000L;
        long seconds = duration % 60000L / 1000L;
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)session.getUniqueId());
        double average = session.getAverage();
        double median = session.getMedian();
        double standardDeviation = session.getStandardDivision();
        double cheatPercent = session.getCheatPercent();
        if (!session.isCheat()) {
            SessionResult result = this.verifySession(session);
            average = result.average();
            median = result.median();
            standardDeviation = result.standardDeviation();
            cheatPercent = ClickAnalyzer.analyzeSession(session.getDifferences()).percent();
            session.update(average, median, standardDeviation, cheatPercent);
        }
        Placeholders placeholders = new Placeholders();
        placeholders.register("clicker", offlinePlayer.getName() == null ? "Unknown" : offlinePlayer.getName());
        placeholders.register("uuid", session.getUniqueId().toString());
        placeholders.register("id", String.valueOf(session.getId()));
        placeholders.register("clicks", format.format(session.getDifferences().size()));
        placeholders.register("average", format.format(average));
        placeholders.register("median", format.format(median));
        placeholders.register("standard-deviation", format.format(standardDeviation));
        placeholders.register("hours", String.valueOf(hours));
        placeholders.register("minutes", String.valueOf(minutes));
        placeholders.register("seconds", String.valueOf(seconds));
        placeholders.register("duration", String.format("%02d:%02d:%02d", hours, minutes, seconds));
        placeholders.register("percent", format.format(cheatPercent));
        placeholders.register("started-at", Config.simpleDateFormat.format(session.getStartedAt()));
        placeholders.register("finished-at", Config.simpleDateFormat.format(session.getFinishedAt()));
        return placeholders;
    }

    public void validSession(Player player, ClickSession session, List<ClickSession> clickSessions) {
        this.plugin.getStorageManager().validSession(session, player);
        clickSessions.removeIf(currentSession -> currentSession.getId() == session.getId());
        player.setMetadata("zaac-invalid-sessions", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, clickSessions));
        this.plugin.getInventoryManager().openInventory(player, (Plugin)this.plugin, "invalid-sessions");
        this.message((CommandSender)player, Message.SESSION_VERIFIED, "%id%", session.getId());
    }
}

