/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import fr.maxlego08.autoclick.ClickListener;
import fr.maxlego08.autoclick.SessionManager;
import fr.maxlego08.autoclick.api.ClickPlugin;
import fr.maxlego08.autoclick.api.utils.Config;
import fr.maxlego08.autoclick.buttons.InvalidSessionButton;
import fr.maxlego08.autoclick.buttons.PlayerButton;
import fr.maxlego08.autoclick.buttons.PlayersButton;
import fr.maxlego08.autoclick.buttons.SessionButton;
import fr.maxlego08.autoclick.buttons.VerifiedInvalidSessionButton;
import fr.maxlego08.autoclick.command.CommandManager;
import fr.maxlego08.autoclick.command.commands.CommandAntiAutoClick;
import fr.maxlego08.autoclick.messages.MessageLoader;
import fr.maxlego08.autoclick.storage.StorageManager;
import fr.maxlego08.autoclick.zcore.ZPlugin;
import fr.maxlego08.autoclick.zcore.utils.plugins.Metrics;
import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.loader.ButtonLoader;
import fr.maxlego08.menu.api.loader.NoneLoader;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import java.util.List;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class ZClickPlugin
extends ZPlugin
implements ClickPlugin {
    private final StorageManager storageManager = new StorageManager(this);
    private final SessionManager sessionManager = new SessionManager(this);
    private final CommandManager commandManager = new CommandManager(this);
    private final MessageLoader messageLoader = new MessageLoader(this);
    private InventoryManager inventoryManager;
    private ButtonManager buttonManager;

    public void onLoad() {
        PacketEvents.setAPI((PacketEventsAPI)SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.inventoryManager = this.getProvider(InventoryManager.class);
        this.buttonManager = this.getProvider(ButtonManager.class);
        Config.load(this.getConfig(), this);
        this.messageLoader.load();
        PacketEvents.getAPI().init();
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new ClickListener(this), PacketListenerPriority.LOW);
        this.storageManager.loadDatabase();
        this.getServer().getPluginManager().registerEvents((Listener)this.sessionManager, (Plugin)this);
        this.commandManager.registerCommand(this, "zantiautoclicks", new CommandAntiAutoClick(this), List.of("zaac"));
        new Metrics(this, 25641);
        this.loadButtons();
        this.loadInventories();
        this.commandManager.validCommands();
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public void reloadFiles() {
        this.reloadConfig();
        Config.load(this.getConfig(), this);
        this.messageLoader.load();
        this.loadInventories();
    }

    @Override
    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    @Override
    public ButtonManager getButtonManager() {
        return this.buttonManager;
    }

    private void loadButtons() {
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, InvalidSessionButton.class, "ZANTIAUTOCLICK_INVALID_SESSIONS"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, VerifiedInvalidSessionButton.class, "ZANTIAUTOCLICK_VERIFIED_INVALID_SESSIONS"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, PlayersButton.class, "ZANTIAUTOCLICK_PLAYERS"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, PlayerButton.class, "ZANTIAUTOCLICK_PLAYER"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, SessionButton.class, "ZANTIAUTOCLICK_CLICKS"));
    }

    private void loadInventories() {
        try {
            this.inventoryManager.loadInventoryOrSaveResource((Plugin)this, "inventories/invalid-sessions.yml");
            this.inventoryManager.loadInventoryOrSaveResource((Plugin)this, "inventories/main-sessions.yml");
            this.inventoryManager.loadInventoryOrSaveResource((Plugin)this, "inventories/player-sessions.yml");
            this.inventoryManager.loadInventoryOrSaveResource((Plugin)this, "inventories/players-sessions.yml");
            this.inventoryManager.loadInventoryOrSaveResource((Plugin)this, "inventories/verified-invalid-sessions.yml");
            this.inventoryManager.loadInventoryOrSaveResource((Plugin)this, "inventories/info-session.yml");
        }
        catch (InventoryException exception) {
            exception.printStackTrace();
        }
    }
}

