/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.buttons;

import fr.maxlego08.autoclick.SessionManager;
import fr.maxlego08.autoclick.ZClickPlugin;
import fr.maxlego08.autoclick.api.ClickSession;
import fr.maxlego08.autoclick.buttons.SessionHelper;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class InvalidSessionButton
extends SessionHelper {
    private final ZClickPlugin plugin;

    public InvalidSessionButton(Plugin plugin) {
        this.plugin = (ZClickPlugin)plugin;
    }

    public boolean hasPermission() {
        return true;
    }

    public boolean checkPermission(Player player, InventoryEngine inventory, Placeholders placeholders) {
        return this.getPaginationSize(player) > 0;
    }

    public boolean hasSpecialRender() {
        return true;
    }

    public boolean isPermanent() {
        return true;
    }

    public void onRender(Player player, InventoryEngine inventory) {
        if (!player.hasMetadata("zaac-invalid-sessions")) {
            return;
        }
        Object object = ((MetadataValue)player.getMetadata("zaac-invalid-sessions").getFirst()).value();
        if (!(object instanceof List)) {
            return;
        }
        List list = (List)object;
        if (list.isEmpty()) {
            return;
        }
        List clickSessions = list.stream().map(e -> (ClickSession)e).collect(Collectors.toList());
        SessionManager sessionManager = this.plugin.getSessionManager();
        this.paginate(clickSessions, inventory, (slot, session) -> {
            ItemStack itemStack = this.createItemStack(player, (ClickSession)session, sessionManager);
            inventory.addItem(slot.intValue(), itemStack).setRightClick(e -> this.plugin.getSessionManager().validSession(player, (ClickSession)session, clickSessions)).setLeftClick(e -> {
                player.setMetadata("zaac-session", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, session));
                InventoryManager manager = this.plugin.getInventoryManager();
                manager.getInventory((Plugin)this.plugin, "info-session").ifPresentOrElse(i -> manager.openInventoryWithOldInventories(player, i, 1), () -> player.sendMessage("\u00a7cImpossible to find the inventory info-session !"));
            });
        });
    }

    public int getPaginationSize(Player player) {
        int n;
        Object object;
        if (player.hasMetadata("zaac-invalid-sessions") && (object = ((MetadataValue)player.getMetadata("zaac-invalid-sessions").getFirst()).value()) instanceof List) {
            List list = (List)object;
            n = list.size();
        } else {
            n = 0;
        }
        return n;
    }
}

