/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.buttons;

import fr.maxlego08.autoclick.SessionManager;
import fr.maxlego08.autoclick.ZClickPlugin;
import fr.maxlego08.autoclick.api.ClickSession;
import fr.maxlego08.autoclick.buttons.SessionHelper;
import fr.maxlego08.autoclick.zcore.utils.PlayerInfo;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PlayerButton
extends SessionHelper {
    private final ZClickPlugin plugin;

    public PlayerButton(Plugin plugin) {
        this.plugin = (ZClickPlugin)plugin;
    }

    public void onInventoryOpen(Player player, InventoryEngine inventory, Placeholders placeholders) {
        super.onInventoryOpen(player, inventory, placeholders);
        if (!player.hasMetadata("zaac-player")) {
            return;
        }
        Object object = ((MetadataValue)player.getMetadata("zaac-player").getFirst()).value();
        if (!(object instanceof PlayerInfo)) {
            return;
        }
        PlayerInfo playerInfo = (PlayerInfo)object;
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerInfo.getUniqueId());
        placeholders.register("target", offlinePlayer.getName() == null ? "Unknown" : offlinePlayer.getName());
    }

    public boolean hasPermission() {
        return true;
    }

    public boolean checkPermission(Player player, InventoryEngine inventory, Placeholders placeholders) {
        return this.getPaginationSize(player) > 0;
    }

    public boolean hasSpecialRender() {
        return true;
    }

    public boolean isPermanent() {
        return true;
    }

    public void onRender(Player player, InventoryEngine inventory) {
        if (!player.hasMetadata("zaac-player")) {
            return;
        }
        Object object = ((MetadataValue)player.getMetadata("zaac-player").getFirst()).value();
        if (!(object instanceof PlayerInfo)) {
            return;
        }
        PlayerInfo playerInfo = (PlayerInfo)object;
        SessionManager sessionManager = this.plugin.getSessionManager();
        this.paginate(playerInfo.getClickSessions(), inventory, (slot, clickSession) -> {
            ItemStack itemStack = this.createItemStack(player, (ClickSession)clickSession, sessionManager);
            inventory.addItem(slot.intValue(), itemStack).setClick(e -> {
                player.setMetadata("zaac-session", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, clickSession));
                InventoryManager manager = this.plugin.getInventoryManager();
                manager.getInventory((Plugin)this.plugin, "info-session").ifPresentOrElse(i -> manager.openInventoryWithOldInventories(player, i, 1), () -> player.sendMessage("\u00a7cImpossible to find the inventory info-session !"));
            });
        });
    }

    public int getPaginationSize(Player player) {
        int n;
        Object object;
        if (player.hasMetadata("zaac-player") && (object = ((MetadataValue)player.getMetadata("zaac-player").getFirst()).value()) instanceof PlayerInfo) {
            PlayerInfo playerInfo = (PlayerInfo)object;
            n = playerInfo.getClickSessions().size();
        } else {
            n = 0;
        }
        return n;
    }
}

