/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.buttons;

import fr.maxlego08.autoclick.ZClickPlugin;
import fr.maxlego08.autoclick.api.ClickSession;
import fr.maxlego08.autoclick.buttons.SessionHelper;
import fr.maxlego08.autoclick.zcore.utils.PlayerInfo;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PlayersButton
extends SessionHelper {
    private final ZClickPlugin plugin;

    public PlayersButton(Plugin plugin) {
        this.plugin = (ZClickPlugin)plugin;
    }

    public boolean hasPermission() {
        return true;
    }

    public boolean checkPermission(Player player, InventoryEngine inventory, Placeholders placeholders) {
        return this.getPaginationSize(player) > 0;
    }

    public boolean hasSpecialRender() {
        return true;
    }

    public boolean isPermanent() {
        return true;
    }

    public void onRender(Player player, InventoryEngine inventory) {
        if (!player.hasMetadata("zaac-players")) {
            return;
        }
        Object object = ((MetadataValue)player.getMetadata("zaac-players").getFirst()).value();
        if (!(object instanceof List)) {
            return;
        }
        List list = (List)object;
        if (list.isEmpty()) {
            return;
        }
        List players = list.stream().map(e -> (PlayerInfo)e).collect(Collectors.toList());
        this.paginate(players, inventory, (slot, playerInfo) -> {
            Placeholders placeholders = new Placeholders();
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerInfo.getUniqueId());
            placeholders.register("target", offlinePlayer.getName() == null ? "Unknown" : offlinePlayer.getName());
            placeholders.register("sessions", String.valueOf(playerInfo.getClickSessions().size()));
            placeholders.register("invalid-sessions", String.valueOf(playerInfo.getClickSessions().stream().filter(ClickSession::isCheat).count()));
            inventory.addItem(slot.intValue(), this.updateSkull(this.getItemStack().build(player, false, placeholders), playerInfo.getUniqueId())).setClick(e -> {
                player.setMetadata("zaac-player", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, playerInfo));
                this.plugin.getInventoryManager().openInventory(player, (Plugin)this.plugin, "player-sessions");
            });
        });
    }

    public int getPaginationSize(Player player) {
        int n;
        Object object;
        if (player.hasMetadata("zaac-players") && (object = ((MetadataValue)player.getMetadata("zaac-players").getFirst()).value()) instanceof List) {
            List list = (List)object;
            n = list.size();
        } else {
            n = 0;
        }
        return n;
    }
}

