/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.buttons;

import fr.maxlego08.autoclick.api.ClickSession;
import fr.maxlego08.autoclick.api.utils.Config;
import fr.maxlego08.autoclick.buttons.SessionHelper;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;

public class SessionButton
extends SessionHelper {
    private final int CLICKS_PER_ITEM = 20;

    public void onInventoryOpen(Player player, InventoryEngine inventory, Placeholders placeholders) {
        super.onInventoryOpen(player, inventory, placeholders);
        if (!player.hasMetadata("zaac-session")) {
            return;
        }
        Object object = ((MetadataValue)player.getMetadata("zaac-session").getFirst()).value();
        if (!(object instanceof ClickSession)) {
            return;
        }
        ClickSession clickSession = (ClickSession)object;
        placeholders.register("id", String.valueOf(clickSession.getId()));
    }

    public boolean hasPermission() {
        return true;
    }

    public boolean checkPermission(Player player, InventoryEngine inventory, Placeholders placeholders) {
        return this.getPaginationSize(player) > 0;
    }

    public boolean hasSpecialRender() {
        return true;
    }

    public boolean isPermanent() {
        return true;
    }

    public void onRender(Player player, InventoryEngine inventory) {
        if (!player.hasMetadata("zaac-session")) {
            return;
        }
        Object object = ((MetadataValue)player.getMetadata("zaac-session").getFirst()).value();
        if (!(object instanceof ClickSession)) {
            return;
        }
        ClickSession session = (ClickSession)object;
        ArrayList list = new ArrayList();
        ArrayList<Integer> tempList = new ArrayList<Integer>();
        for (Integer difference : session.getDifferences()) {
            tempList.add(difference);
            if (tempList.size() != 20) continue;
            list.add(new ArrayList(tempList));
            tempList.clear();
        }
        if (!tempList.isEmpty()) {
            list.add(new ArrayList(tempList));
        }
        this.paginate(list, inventory, (slot, clicks) -> {
            Placeholders placeholders = new Placeholders();
            placeholders.register("clicks", clicks.stream().map(e -> Config.clickLoreLine.replace("%click%", String.valueOf(e))).collect(Collectors.joining("\n")));
            inventory.addItem(slot.intValue(), this.getItemStack().build(player, false, placeholders));
        });
    }

    public int getPaginationSize(Player player) {
        int n;
        Object object;
        if (player.hasMetadata("zaac-session") && (object = ((MetadataValue)player.getMetadata("zaac-session").getFirst()).value()) instanceof ClickSession) {
            ClickSession session = (ClickSession)object;
            n = session.getDifferences().size() / 20;
        } else {
            n = 0;
        }
        return n;
    }
}

