/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.libs;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import fr.maxlego08.autoclick.libs.DatabaseConfiguration;
import fr.maxlego08.autoclick.libs.DatabaseConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class HikariDatabaseConnection
extends DatabaseConnection {
    private static final AtomicInteger POOL_COUNTER = new AtomicInteger(0);
    private static final int MAXIMUM_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2 + 1;
    private static final int MINIMUM_IDLE = Math.min(MAXIMUM_POOL_SIZE, 10);
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final long LEAK_DETECTION_THRESHOLD = TimeUnit.SECONDS.toMillis(10L);
    private HikariDataSource dataSource;

    public HikariDatabaseConnection(DatabaseConfiguration databaseConfiguration) {
        super(databaseConfiguration);
        this.initializeDataSource();
    }

    private void initializeDataSource() {
        HikariConfig config = new HikariConfig();
        config.setPoolName("sarah-" + POOL_COUNTER.getAndIncrement());
        config.setJdbcUrl("jdbc:mysql://" + this.databaseConfiguration.getHost() + ":" + this.databaseConfiguration.getPort() + "/" + this.databaseConfiguration.getDatabase() + "?allowMultiQueries=true");
        config.setUsername(this.databaseConfiguration.getUser());
        config.setPassword(this.databaseConfiguration.getPassword());
        config.setMaximumPoolSize(MAXIMUM_POOL_SIZE);
        config.setMinimumIdle(MINIMUM_IDLE);
        config.setMaxLifetime(MAX_LIFETIME);
        config.setConnectionTimeout(CONNECTION_TIMEOUT);
        config.setLeakDetectionThreshold(LEAK_DETECTION_THRESHOLD);
        HashMap<String, String> properties = new HashMap<String, String>(){
            {
                this.put("useSSL", "false");
                this.put("useUnicode", "true");
                this.put("characterEncoding", "utf8");
                this.put("cachePrepStmts", "true");
                this.put("prepStmtCacheSize", "250");
                this.put("prepStmtCacheSqlLimit", "2048");
                this.put("useServerPrepStmts", "true");
                this.put("useLocalSessionState", "true");
                this.put("rewriteBatchedStatements", "true");
                this.put("cacheResultSetMetadata", "true");
                this.put("cacheServerConfiguration", "true");
                this.put("elideSetAutoCommits", "true");
                this.put("maintainTimeStats", "false");
                this.put("alwaysSendSetIsolation", "false");
                this.put("cacheCallableStmts", "true");
                this.put("socketTimeout", String.valueOf(TimeUnit.SECONDS.toMillis(30L)));
            }
        };
        for (Map.Entry property : properties.entrySet()) {
            config.addDataSourceProperty((String)property.getKey(), property.getValue());
        }
        this.dataSource = new HikariDataSource(config);
    }

    @Override
    public Connection connectToDatabase() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    @Override
    public boolean isValid() {
        return this.dataSource != null && this.dataSource.isRunning();
    }

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    protected boolean isConnected(Connection connection) {
        try {
            return connection != null && connection.isValid(1);
        }
        catch (SQLException exception) {
            return false;
        }
    }
}

