/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.libs;

import fr.maxlego08.autoclick.libs.DatabaseConfiguration;
import fr.maxlego08.autoclick.libs.DatabaseConnection;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;

public class SqliteConnection
extends DatabaseConnection {
    private final File folder;
    private String fileName = "database.db";

    public SqliteConnection(DatabaseConfiguration databaseConfiguration, File folder) {
        super(databaseConfiguration);
        this.folder = folder;
    }

    @Override
    public Connection connectToDatabase() throws Exception {
        File databaseFile;
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        if (!(databaseFile = new File(this.folder, this.fileName)).exists()) {
            databaseFile.createNewFile();
        }
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return DriverManager.getConnection("jdbc:sqlite:" + databaseFile.getAbsolutePath());
    }

    public File getFolder() {
        return this.folder;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public Connection getConnection() {
        try {
            return this.connectToDatabase();
        }
        catch (Exception exception) {
            this.connect();
            return this.connection;
        }
    }
}

