/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.libs.conditions;

import fr.maxlego08.autoclick.libs.DatabaseConfiguration;
import fr.maxlego08.autoclick.libs.database.DatabaseType;

public class ColumnDefinition {
    private String name;
    private String type;
    private int length;
    private int decimal;
    private boolean nullable = false;
    private String defaultValue;
    private boolean isPrimaryKey = false;
    private String referenceTable;
    private Object object;
    private boolean isAutoIncrement;
    private boolean unique = false;

    public ColumnDefinition(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public ColumnDefinition(String name) {
        this.name = name;
    }

    public String build(DatabaseConfiguration databaseConfiguration) {
        StringBuilder columnSQL = new StringBuilder("`" + this.name + "` " + this.type);
        if (this.length != 0 && this.decimal != 0) {
            columnSQL.append("(").append(this.length).append(",").append(this.decimal).append(")");
        } else if (this.length != 0) {
            columnSQL.append("(").append(this.length).append(")");
        }
        if (this.isAutoIncrement && databaseConfiguration.getDatabaseType() != DatabaseType.SQLITE) {
            columnSQL.append(" AUTO_INCREMENT");
        }
        if (this.nullable) {
            columnSQL.append(" NULL");
        } else {
            columnSQL.append(" NOT NULL");
        }
        if (this.defaultValue != null) {
            columnSQL.append(" DEFAULT ").append(this.defaultValue);
        }
        if (this.unique) {
            columnSQL.append(" UNIQUE");
        }
        return columnSQL.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSafeName() {
        return String.format("`%s`", this.name);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getLength() {
        return this.length;
    }

    public ColumnDefinition setLength(Integer length) {
        this.length = length;
        return this;
    }

    public ColumnDefinition setLength(int length) {
        this.length = length;
        return this;
    }

    public ColumnDefinition setDecimal(Integer decimal) {
        this.decimal = decimal;
        return this;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.isPrimaryKey = primaryKey;
    }

    public String getReferenceTable() {
        return this.referenceTable;
    }

    public void setReferenceTable(String referenceTable) {
        this.referenceTable = referenceTable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public Object getObject() {
        return this.object;
    }

    public ColumnDefinition setObject(Object object) {
        this.object = object;
        return this;
    }

    public ColumnDefinition setAutoIncrement(boolean isAutoIncrement) {
        this.isAutoIncrement = isAutoIncrement;
        return this;
    }
}

