/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.libs.conditions;

public class JoinCondition {
    private final String primaryTable;
    private final String primaryTableAlias;
    private final String primaryColumn;
    private final String foreignTable;
    private final String foreignColumn;
    private final JoinType joinType;
    private final JoinCondition additionalCondition;

    public JoinCondition(JoinType joinType, String primaryTable, String primaryTableAlias, String primaryColumn, String foreignTable, String foreignColumn, JoinCondition additionalCondition) {
        this.primaryTable = primaryTable;
        this.primaryTableAlias = primaryTableAlias;
        this.primaryColumn = primaryColumn;
        this.foreignTable = foreignTable;
        this.foreignColumn = foreignColumn;
        this.joinType = joinType;
        this.additionalCondition = additionalCondition;
    }

    public static JoinCondition and(String primaryTableAlias, String primaryColumn, String foreignColumn) {
        return new JoinCondition(null, null, primaryTableAlias, primaryColumn, null, foreignColumn, null);
    }

    public String getJoinClause() {
        StringBuilder joinClause = new StringBuilder();
        joinClause.append(this.joinType.getSql()).append(" ").append(this.primaryTable).append(" AS ").append(this.primaryTableAlias).append(" ON ").append(this.primaryTableAlias).append(".").append(this.primaryColumn).append(" = ").append(this.foreignTable).append(".").append(this.foreignColumn);
        if (this.additionalCondition != null) {
            joinClause.append(" AND ").append(this.additionalCondition.getCondition());
        }
        return joinClause.toString();
    }

    private String getCondition() {
        return this.primaryTableAlias + "." + this.primaryColumn + " = '" + this.foreignColumn + "'";
    }

    public static enum JoinType {
        INNER("INNER JOIN"),
        LEFT("LEFT JOIN"),
        RIGHT("RIGHT JOIN"),
        FULL("FULL OUTER JOIN");

        private final String sql;

        private JoinType(String sql) {
            this.sql = sql;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

