/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.libs.conditions;

import java.util.Objects;

public class SelectCondition {
    private final String tablePrefix;
    private final String column;
    private final String aliases;
    private final boolean isCoalesce;
    private final Object defaultValue;

    public SelectCondition(String tablePrefix, String column, String aliases, boolean isCoalesce, Object defaultValue) {
        this.tablePrefix = tablePrefix;
        this.column = column;
        this.aliases = aliases;
        this.isCoalesce = isCoalesce;
        this.defaultValue = defaultValue;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean isCoalesce() {
        return this.isCoalesce;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getSelectColumn() {
        String result;
        String string = result = this.tablePrefix == null ? this.getColumnAndAliases() : this.tablePrefix + "." + this.getColumnAndAliases();
        if (this.isCoalesce) {
            String tableName = this.tablePrefix == null ? "`" + this.column + "`" : this.tablePrefix + ".`" + this.column + "`";
            return "COALESCE(" + tableName + ", " + this.defaultValue + ")" + this.getAliases();
        }
        return result;
    }

    private String getColumnAndAliases() {
        return "`" + this.column + "`" + this.getAliases();
    }

    private String getAliases() {
        return this.aliases == null ? "" : " as " + this.aliases;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectCondition that = (SelectCondition)o;
        return this.isCoalesce == that.isCoalesce && Objects.equals(this.tablePrefix, that.tablePrefix) && Objects.equals(this.column, that.column) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.tablePrefix, this.column, this.aliases, this.isCoalesce, this.defaultValue);
    }

    public String toString() {
        return "SelectCondition{tablePrefix='" + this.tablePrefix + '\'' + ", column='" + this.column + '\'' + ", aliases='" + this.aliases + '\'' + ", isCoalesce=" + this.isCoalesce + ", defaultValue=" + this.defaultValue + '}';
    }
}

