/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.libs.requests;

import fr.maxlego08.autoclick.libs.DatabaseConfiguration;
import fr.maxlego08.autoclick.libs.DatabaseConnection;
import fr.maxlego08.autoclick.libs.conditions.ColumnDefinition;
import fr.maxlego08.autoclick.libs.database.Executor;
import fr.maxlego08.autoclick.libs.database.Schema;
import fr.maxlego08.autoclick.libs.logger.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;

public class AlterRequest
implements Executor {
    private final Schema schema;

    public AlterRequest(Schema schema) {
        this.schema = schema;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DatabaseConnection databaseConnection, DatabaseConfiguration databaseConfiguration, Logger logger) {
        StringBuilder alterTableSQL = new StringBuilder("ALTER TABLE ");
        alterTableSQL.append(this.schema.getTableName()).append(" ");
        ArrayList<String> columnSQLs = new ArrayList<String>();
        for (ColumnDefinition column : this.schema.getColumns()) {
            columnSQLs.add("ADD COLUMN " + column.build(databaseConfiguration));
        }
        alterTableSQL.append(String.join((CharSequence)", ", columnSQLs));
        if (!this.schema.getPrimaryKeys().isEmpty()) {
            alterTableSQL.append(", PRIMARY KEY (").append(String.join((CharSequence)", ", this.schema.getPrimaryKeys())).append(")");
        }
        for (String fk : this.schema.getForeignKeys()) {
            alterTableSQL.append(", ADD ").append(fk);
        }
        String finalQuery = databaseConfiguration.replacePrefix(alterTableSQL.toString());
        if (databaseConfiguration.isDebug()) {
            logger.info("Executing SQL: " + finalQuery);
        }
        try (Connection connection = databaseConnection.getConnection();){
            int n;
            block18: {
                PreparedStatement preparedStatement = connection.prepareStatement(finalQuery);
                try {
                    preparedStatement.execute();
                    n = preparedStatement.getUpdateCount();
                    if (preparedStatement == null) break block18;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return -1;
        }
    }
}

