/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.libs.requests;

import fr.maxlego08.autoclick.libs.DatabaseConfiguration;
import fr.maxlego08.autoclick.libs.DatabaseConnection;
import fr.maxlego08.autoclick.libs.conditions.ColumnDefinition;
import fr.maxlego08.autoclick.libs.database.Executor;
import fr.maxlego08.autoclick.libs.database.Schema;
import fr.maxlego08.autoclick.libs.logger.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CreateIndexRequest
implements Executor {
    private final Schema schema;

    public CreateIndexRequest(Schema schema) {
        this.schema = schema;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DatabaseConnection databaseConnection, DatabaseConfiguration databaseConfiguration, Logger logger) {
        StringBuilder indexTableSQL = new StringBuilder("CREATE INDEX ");
        String tableName = this.schema.getTableName();
        ColumnDefinition column = this.schema.getColumns().get(0);
        String indexName = "idx_" + tableName + "_" + column.getName();
        indexTableSQL.append(indexName);
        indexTableSQL.append(" ON ");
        indexTableSQL.append(String.format("`%s`", tableName));
        indexTableSQL.append(" (");
        indexTableSQL.append(column.getSafeName());
        indexTableSQL.append(" )");
        String finalQuery = databaseConfiguration.replacePrefix(indexTableSQL.toString());
        if (databaseConfiguration.isDebug()) {
            logger.info("Executing SQL: " + finalQuery);
        }
        try (Connection connection = databaseConnection.getConnection();){
            int n;
            block15: {
                PreparedStatement preparedStatement = connection.prepareStatement(finalQuery);
                try {
                    preparedStatement.execute();
                    n = preparedStatement.getUpdateCount();
                    if (preparedStatement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return -1;
        }
    }
}

