/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.libs.requests;

import fr.maxlego08.autoclick.libs.DatabaseConfiguration;
import fr.maxlego08.autoclick.libs.DatabaseConnection;
import fr.maxlego08.autoclick.libs.conditions.ColumnDefinition;
import fr.maxlego08.autoclick.libs.conditions.JoinCondition;
import fr.maxlego08.autoclick.libs.database.Executor;
import fr.maxlego08.autoclick.libs.database.Schema;
import fr.maxlego08.autoclick.libs.logger.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class UpdateBatchRequest
implements Executor {
    private final List<Schema> schemas;

    public UpdateBatchRequest(List<Schema> schemas) {
        this.schemas = schemas;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DatabaseConnection databaseConnection, DatabaseConfiguration databaseConfiguration, Logger logger) {
        if (this.schemas.isEmpty()) {
            return 0;
        }
        Schema firstSchema = this.schemas.get(0);
        StringBuilder updateQuery = new StringBuilder("UPDATE " + firstSchema.getTableName());
        if (!firstSchema.getJoinConditions().isEmpty()) {
            for (JoinCondition join : firstSchema.getJoinConditions()) {
                updateQuery.append(" ").append(join.getJoinClause());
            }
        }
        updateQuery.append(" SET ");
        List<ColumnDefinition> columns = firstSchema.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnDefinition columnDefinition = columns.get(i);
            updateQuery.append(i > 0 ? ", " : "").append(columnDefinition.getSafeName()).append(" = ?");
        }
        firstSchema.whereConditions(updateQuery);
        String updateSql = databaseConfiguration.replacePrefix(updateQuery.toString());
        if (databaseConfiguration.isDebug()) {
            logger.info("Executing SQL Batch: " + updateSql);
        }
        try (Connection connection = databaseConnection.getConnection();){
            int n;
            block22: {
                PreparedStatement preparedStatement = connection.prepareStatement(updateSql);
                try {
                    for (Schema schema : this.schemas) {
                        List<ColumnDefinition> schemaColumns = schema.getColumns();
                        for (int i = 0; i < schemaColumns.size(); ++i) {
                            preparedStatement.setObject(i + 1, schemaColumns.get(i).getObject());
                        }
                        schema.applyWhereConditions(preparedStatement, schemaColumns.size() + 1);
                        preparedStatement.addBatch();
                    }
                    int[] results = preparedStatement.executeBatch();
                    int total = 0;
                    for (int count : results) {
                        total += count;
                    }
                    n = total;
                    if (preparedStatement == null) break block22;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return -1;
        }
    }
}

