/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.storage;

import fr.maxlego08.autoclick.Session;
import fr.maxlego08.autoclick.ZClickPlugin;
import fr.maxlego08.autoclick.api.ClickSession;
import fr.maxlego08.autoclick.api.result.AnalyzeResult;
import fr.maxlego08.autoclick.api.result.SessionResult;
import fr.maxlego08.autoclick.api.storage.StorageType;
import fr.maxlego08.autoclick.api.storage.dto.InvalidSessionDTO;
import fr.maxlego08.autoclick.api.storage.dto.SessionDTO;
import fr.maxlego08.autoclick.libs.DatabaseConfiguration;
import fr.maxlego08.autoclick.libs.DatabaseConnection;
import fr.maxlego08.autoclick.libs.HikariDatabaseConnection;
import fr.maxlego08.autoclick.libs.MigrationManager;
import fr.maxlego08.autoclick.libs.RequestHelper;
import fr.maxlego08.autoclick.libs.SqliteConnection;
import fr.maxlego08.autoclick.libs.database.DatabaseType;
import fr.maxlego08.autoclick.libs.logger.JULogger;
import fr.maxlego08.autoclick.migrations.InvalidSessionMigration;
import fr.maxlego08.autoclick.migrations.SessionMigration;
import fr.maxlego08.autoclick.storage.GlobalDatabaseConfiguration;
import fr.maxlego08.autoclick.zcore.utils.PlayerInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class StorageManager {
    private final ZClickPlugin plugin;
    private RequestHelper requestHelper;

    public StorageManager(ZClickPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadDatabase() {
        DatabaseConnection connection;
        FileConfiguration configuration = this.plugin.getConfig();
        StorageType storageType = StorageType.valueOf(configuration.getString("storage-type", StorageType.SQLITE.name()).toUpperCase());
        DatabaseConfiguration databaseConfiguration = this.getDatabaseConfiguration(configuration, storageType);
        switch (storageType) {
            default: {
                throw new MatchException(null, null);
            }
            case SQLITE: {
                DatabaseConnection databaseConnection = new SqliteConnection(databaseConfiguration, this.plugin.getDataFolder());
                break;
            }
            case HIKARICP: 
            case MYSQL: {
                DatabaseConnection databaseConnection = connection = new HikariDatabaseConnection(databaseConfiguration);
            }
        }
        if (!connection.isValid()) {
            this.plugin.getLogger().severe("Unable to connect to database!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
        } else if (storageType == StorageType.SQLITE) {
            this.plugin.getLogger().info("The database connection is valid! (SQLITE)");
        } else {
            this.plugin.getLogger().info("The database connection is valid! (" + connection.getDatabaseConfiguration().getHost() + ")");
        }
        this.requestHelper = new RequestHelper(connection, JULogger.from(this.plugin.getLogger()));
        MigrationManager.setMigrationTableName("zantiautoclick_migrations");
        MigrationManager.registerMigration(new SessionMigration());
        MigrationManager.registerMigration(new InvalidSessionMigration());
        MigrationManager.execute(connection, JULogger.from(this.plugin.getLogger()));
    }

    private DatabaseConfiguration getDatabaseConfiguration(FileConfiguration configuration, StorageType storageType) {
        GlobalDatabaseConfiguration globalDatabaseConfiguration = new GlobalDatabaseConfiguration(configuration);
        String tablePrefix = globalDatabaseConfiguration.getTablePrefix();
        String host = globalDatabaseConfiguration.getHost();
        int port = globalDatabaseConfiguration.getPort();
        String user = globalDatabaseConfiguration.getUser();
        String password = globalDatabaseConfiguration.getPassword();
        String database = globalDatabaseConfiguration.getDatabase();
        boolean debug = globalDatabaseConfiguration.isDebug();
        return new DatabaseConfiguration(tablePrefix, user, password, port, host, database, debug, storageType == StorageType.SQLITE ? DatabaseType.SQLITE : DatabaseType.MYSQL);
    }

    public void insertSession(UUID uuid, Session session, Consumer<Integer> consumer) {
        this.async(() -> this.requestHelper.insert("%prefix%sessions", table -> {
            table.uuid("unique_id", uuid);
            table.string("differences", session.getDifferences().stream().map(String::valueOf).collect(Collectors.joining(",")));
            table.object("started_at", new Date(session.getStartedAt()));
            table.object("finished_at", new Date(session.getFinishedAt()));
        }, consumer));
    }

    public void insertInvalidSession(Session session, SessionResult sessionResult, AnalyzeResult analyzeResult, Consumer<InvalidSessionDTO> consumer) {
        this.async(() -> this.requestHelper.insert("%prefix%invalid_sessions", table -> {
            table.bigInt("session_id", session.getId());
            table.decimal("result", analyzeResult.percent());
            table.decimal("average", sessionResult.average());
            table.decimal("median", sessionResult.median());
            table.decimal("standard_deviation", sessionResult.standardDeviation());
        }, id -> consumer.accept(new InvalidSessionDTO((int)id, session.getId(), analyzeResult.percent(), sessionResult.average(), sessionResult.median(), sessionResult.standardDeviation(), null, null))));
    }

    public void select(int id, Consumer<SessionDTO> consumer) {
        this.async(() -> {
            List<SessionDTO> values = this.requestHelper.select("%prefix%sessions", SessionDTO.class, table -> table.where("id", id));
            consumer.accept(values.isEmpty() ? null : values.getFirst());
        });
    }

    public List<SessionDTO> select() {
        return this.requestHelper.selectAll("%prefix%sessions", SessionDTO.class);
    }

    public void clean() {
        this.async(() -> {
            for (SessionDTO value : this.select()) {
                if (value.isValid()) continue;
                this.requestHelper.delete("%prefix%sessions", table -> table.where("id", value.id()));
            }
        });
    }

    private void async(Runnable runnable) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, runnable);
    }

    public void select(Consumer<List<SessionDTO>> consumer) {
        this.async(() -> consumer.accept(this.select()));
    }

    public List<ClickSession> getSessions(UUID uniqueId) {
        List<SessionDTO> sessions = this.requestHelper.select("%prefix%sessions", SessionDTO.class, table -> table.where("unique_id", uniqueId));
        List<String> ids = sessions.stream().map(e -> String.valueOf(e.id())).toList();
        List<InvalidSessionDTO> invalidSessions = this.requestHelper.select("%prefix%invalid_sessions", InvalidSessionDTO.class, table -> table.whereIn("session_id", ids));
        ArrayList<ClickSession> clickSessions = new ArrayList<ClickSession>();
        for (SessionDTO session : sessions) {
            Session clickSession = new Session(session.getUniqueId(), session.started_at().getTime(), session.finished_at().getTime(), session.getDifferences());
            clickSession.setId(session.id());
            invalidSessions.stream().filter(e -> e.session_id() == clickSession.getId()).findFirst().ifPresent(clickSession::setInvalidSession);
            clickSessions.add(clickSession);
        }
        return clickSessions;
    }

    public void getInvalidSessions(Consumer<List<ClickSession>> consumer) {
        this.async(() -> this.verified(this.requestHelper.select("%prefix%invalid_sessions", InvalidSessionDTO.class, table -> table.whereNull("verified_by")), consumer));
    }

    public void getVerifiedInvalidSessions(Consumer<List<ClickSession>> consumer) {
        this.async(() -> this.verified(this.requestHelper.select("%prefix%invalid_sessions", InvalidSessionDTO.class, table -> table.whereNotNull("verified_by")), consumer));
    }

    public void getPlayers(Consumer<List<PlayerInfo>> consumer) {
        this.async(() -> {
            HashMap<UUID, List> playerSessions = new HashMap<UUID, List>();
            List<SessionDTO> sessions = this.requestHelper.selectAll("%prefix%sessions", SessionDTO.class);
            List<InvalidSessionDTO> invalidSessions = this.requestHelper.selectAll("%prefix%invalid_sessions", InvalidSessionDTO.class);
            for (SessionDTO session : sessions) {
                Session clickSession = new Session(session.getUniqueId(), session.started_at().getTime(), session.finished_at().getTime(), session.getDifferences());
                clickSession.setId(session.id());
                invalidSessions.stream().filter(e -> e.session_id() == clickSession.getId()).findFirst().ifPresent(clickSession::setInvalidSession);
                playerSessions.computeIfAbsent(session.getUniqueId(), k -> new ArrayList()).add(clickSession);
            }
            consumer.accept(playerSessions.entrySet().stream().map(e -> new PlayerInfo((UUID)e.getKey(), (List)e.getValue())).toList());
        });
    }

    private void verified(List<InvalidSessionDTO> invalidSessions, Consumer<List<ClickSession>> consumer) {
        List<String> ids = invalidSessions.stream().map(e -> String.valueOf(e.session_id())).toList();
        List<SessionDTO> sessions = this.requestHelper.select("%prefix%sessions", SessionDTO.class, table -> table.whereIn("id", ids));
        ArrayList clickSessions = new ArrayList();
        for (SessionDTO session : sessions) {
            Session clickSession = new Session(session.getUniqueId(), session.started_at().getTime(), session.finished_at().getTime(), session.getDifferences());
            clickSession.setId(session.id());
            invalidSessions.stream().filter(e -> e.session_id() == clickSession.getId()).findFirst().ifPresent(e -> {
                clickSession.setInvalidSession((InvalidSessionDTO)e);
                clickSessions.add(clickSession);
            });
        }
        consumer.accept(clickSessions.stream().sorted(Comparator.comparingLong(ClickSession::getStartedAt).reversed()).toList());
    }

    public void validSession(ClickSession session, Player player) {
        this.async(() -> this.requestHelper.update("%prefix%invalid_sessions", table -> {
            table.uuid("verified_by", player.getUniqueId());
            table.object("verified_at", new Date());
            table.where("session_id", session.getId());
        }));
    }
}

