/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.zcore.enums;

import fr.maxlego08.autoclick.zcore.enums.MessageType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public enum Message {
    PREFIX("&8(&6zAntiAutoClick&8) "),
    COMMAND_SYNTAX_ERROR("&cYou must execute the command like this&7: &a%syntax%"),
    COMMAND_NO_PERMISSION("&cYou do not have permission to run this command."),
    COMMAND_NO_CONSOLE("&cOnly one player can execute this command."),
    COMMAND_NO_ARG("&cImpossible to find the command with its arguments."),
    COMMAND_SYNTAX_HELP("&f%syntax% &7\u00bb &7%description%"),
    RELOAD("&aYou have just reloaded the configuration files."),
    DESCRIPTION_RELOAD("Reload configuration files"),
    DESCRIPTION_SHOW("Display a session"),
    DESCRIPTION_SHOW_DURATION("Display all sessions with a specific duration"),
    DESCRIPTION_SHOW_ALL("Display all sessions"),
    DESCRIPTION_CLEAN("Clean your database"),
    DESCRIPTION_SUSPECT("Display suspect sessions"),
    DESCRIPTION_OPEN("Open main inventory"),
    DESCRIPTION_OPEN_INVALID_SESSIONS("Open invalid sessions inventory"),
    DESCRIPTION_OPEN_VERIFIED_INVALID_SESSIONS("Open verified invalid sessions inventory"),
    DESCRIPTION_OPEN_PLAYERS_SESSIONS("Open players sessions inventory"),
    SESSION_NOT_FOUND("&cImpossible to find the session &f%id%&c."),
    CLEAN("&aThe database has been cleaned."),
    SESSION_INFORMATION("&fUUID&8: &7%uuid% &8(&7id: %id%&8)", "&fMedian&8: &7%median%ms", "&fAverage&8: &7%average%ms", "&fStandard Deviation&8: %color%%standard-deviation%", "&fDuration&8: &7%duration%", "&fPercent&8: %color-percent%%percent%%", "&fIs a cheater&8: %color-cheat%%cheat%"),
    SESSION_VERIFIED("&aYou just checked the session &f%id%&a");

    private List<String> messages;
    private String message;
    private Map<String, Object> titles = new HashMap<String, Object>();
    private boolean use = true;
    private MessageType type = MessageType.TCHAT;
    private ItemStack itemStack;

    private Message(String message) {
        this.message = message;
        this.use = true;
    }

    private Message(String title, String subTitle, int a, int b, int c) {
        this.use = true;
        this.titles.put("title", title);
        this.titles.put("subtitle", subTitle);
        this.titles.put("start", a);
        this.titles.put("time", b);
        this.titles.put("end", c);
        this.titles.put("isUse", true);
        this.type = MessageType.TITLE;
    }

    private Message(String ... message) {
        this.messages = Arrays.asList(message);
        this.use = true;
    }

    private Message(MessageType type, String ... message) {
        this.messages = Arrays.asList(message);
        this.use = true;
        this.type = type;
    }

    private Message(MessageType type, String message) {
        this.message = message;
        this.use = true;
        this.type = type;
    }

    private Message(String message, boolean use) {
        this.message = message;
        this.use = use;
    }

    public String getMessage() {
        return this.message;
    }

    public String toMsg() {
        return this.message;
    }

    public String msg() {
        return this.message;
    }

    public boolean isUse() {
        return this.use;
    }

    public List<String> getMessages() {
        return this.messages == null ? Collections.singletonList(this.message) : this.messages;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public boolean isMessage() {
        return this.messages != null && this.messages.size() > 1;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTitle() {
        return (String)this.titles.get("title");
    }

    public Map<String, Object> getTitles() {
        return this.titles;
    }

    public void setTitles(Map<String, Object> titles) {
        this.titles = titles;
        this.type = MessageType.TITLE;
    }

    public String getSubTitle() {
        return (String)this.titles.get("subtitle");
    }

    public boolean isTitle() {
        return this.titles.containsKey("title");
    }

    public int getStart() {
        return ((Number)this.titles.get("start")).intValue();
    }

    public int getEnd() {
        return ((Number)this.titles.get("end")).intValue();
    }

    public int getTime() {
        return ((Number)this.titles.get("time")).intValue();
    }

    public boolean isUseTitle() {
        return (Boolean)this.titles.getOrDefault("isUse", "true");
    }

    public String replace(String a, String b) {
        return this.message.replace(a, b);
    }

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }
}

