/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.zcore.utils;

import fr.maxlego08.autoclick.zcore.enums.Message;
import fr.maxlego08.autoclick.zcore.enums.MessageType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public abstract class ZUtils {
    protected boolean hasPermission(Permissible permissible, String permission) {
        return permissible.hasPermission(permission);
    }

    protected void message(CommandSender sender, String message, Object ... args) {
        sender.sendMessage(Message.PREFIX.msg() + this.getMessage(message, args));
    }

    private void message(CommandSender sender, String message) {
        sender.sendMessage(this.color(message));
    }

    protected void message(CommandSender sender, Message message, Object ... args) {
        if (sender instanceof ConsoleCommandSender) {
            if (!message.getMessages().isEmpty()) {
                message.getMessages().forEach(msg -> this.message(sender, this.getMessage((String)msg, args)));
            } else {
                this.message(sender, Message.PREFIX.msg() + this.getMessage(message, args));
            }
        } else {
            Player player = (Player)sender;
            switch (message.getType()) {
                case CENTER: {
                    if (!message.getMessages().isEmpty()) {
                        message.getMessages().forEach(msg -> sender.sendMessage(this.getCenteredMessage(this.papi(this.getMessage((String)msg, args), player))));
                        break;
                    }
                    sender.sendMessage(this.getCenteredMessage(this.papi(this.getMessage(message, args), player)));
                    break;
                }
                case ACTION: {
                    this.actionMessage(player, message, args);
                    break;
                }
                case TCHAT_AND_ACTION: {
                    this.actionMessage(player, message, args);
                    this.sendTchatMessage(player, message, args);
                    break;
                }
                case TCHAT: 
                case WITHOUT_PREFIX: {
                    this.sendTchatMessage(player, message, args);
                    break;
                }
                case TITLE: {
                    String title = message.getTitle();
                    String subTitle = message.getSubTitle();
                    int fadeInTime = message.getStart();
                    int showTime = message.getTime();
                    int fadeOutTime = message.getEnd();
                    this.title(player, this.papi(this.getMessage(title, args), player), this.papi(this.getMessage(subTitle, args), player), fadeInTime, showTime, fadeOutTime);
                    break;
                }
            }
        }
    }

    protected String getMessage(Message message, Object ... args) {
        return this.getMessage(message.getMessage(), args);
    }

    protected String getMessage(String message, Object ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Number of invalid arguments. Arguments must be in pairs.");
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i] == null || args[i + 1] == null) {
                throw new IllegalArgumentException("Keys and replacement values must not be null.");
            }
            message = message.replace(args[i].toString(), args[i + 1].toString());
        }
        return message;
    }

    protected String color(String message) {
        if (message == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String color = message.substring(matcher.start(), matcher.end());
            message = message.replace(color, String.valueOf(ChatColor.of((String)color)));
            matcher = pattern.matcher(message);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private void sendTchatMessage(Player player, Message message, Object ... args) {
        if (message.getMessages().size() > 1) {
            message.getMessages().forEach(msg -> this.message((CommandSender)player, this.papi(this.getMessage((String)msg, args), player)));
        } else {
            this.message((CommandSender)player, this.papi((message.getType() == MessageType.WITHOUT_PREFIX ? "" : Message.PREFIX.msg()) + this.getMessage(message, args), player));
        }
    }

    public String papi(String string, Player player) {
        return string;
    }

    protected void actionMessage(Player player, Message message, Object ... args) {
    }

    protected void title(Player player, String title, String subtitle, int fadeInTime, int showTime, int fadeOutTime) {
    }

    protected String getCenteredMessage(String message) {
        return message;
    }
}

