/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.autoclick.zcore.utils.plugins;

import fr.maxlego08.autoclick.ZClickPlugin;
import fr.maxlego08.autoclick.zcore.utils.ZUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class VersionChecker
extends ZUtils
implements Listener {
    private final String URL_API = "https://groupez.dev/api/v1/resource/version/%s";
    private final String URL_RESOURCE = "https://groupez.dev/resources/%s";
    private final ZClickPlugin plugin;
    private final int pluginID;
    private boolean useLastVersion = false;

    public VersionChecker(ZClickPlugin plugin, int pluginID) {
        this.plugin = plugin;
        this.pluginID = pluginID;
    }

    public void useLastVersion() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        String pluginVersion = this.plugin.getDescription().getVersion();
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        this.getVersion(version -> {
            long ver = Long.parseLong(version.replace(".", ""));
            long plVersion = Long.parseLong(pluginVersion.replace(".", ""));
            atomicBoolean.set(plVersion >= ver);
            this.useLastVersion = atomicBoolean.get();
            if (atomicBoolean.get()) {
                this.plugin.getLogger().info("No update available.");
            } else {
                this.plugin.getLogger().warning("New update available. Your version: " + pluginVersion + ", latest version: " + version);
                this.plugin.getLogger().warning("Download plugin here: " + String.format("https://groupez.dev/resources/%s", this.pluginID));
            }
        });
    }

    @EventHandler
    public void onConnect(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.useLastVersion && event.getPlayer().hasPermission("zplugin.notifs")) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.message((CommandSender)player, "&cYou do not use the latest version of the plugin! Thank you for taking the latest version to avoid any risk of problem!", new Object[0]);
                this.message((CommandSender)player, "&fDownload plugin here: &a" + String.format("https://groupez.dev/resources/%s", this.pluginID), new Object[0]);
            }, 40L);
        }
    }

    public void getVersion(Consumer<String> consumer) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String apiURL = String.format("https://groupez.dev/api/v1/resource/version/%s", this.pluginID);
            try {
                URL url = URI.create(apiURL).toURL();
                URLConnection hc = url.openConnection();
                hc.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
                Scanner scanner = new Scanner(hc.getInputStream());
                if (scanner.hasNext()) {
                    consumer.accept(scanner.next());
                }
                scanner.close();
            }
            catch (IOException exception) {
                this.plugin.getLogger().info("Cannot look for updates: " + exception.getMessage());
            }
        });
    }
}

