/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.recursiveae2patternprovider;

import appeng.core.definitions.AEItems;
import com.lumengrid.recursiveae2patternprovider.RecursiveAE2PatternProvider;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class PatternUtil {
    public static boolean isAE2Pattern(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        try {
            return stack.is(AEItems.CRAFTING_PATTERN.asItem()) || stack.is(AEItems.PROCESSING_PATTERN.asItem()) || stack.is(AEItems.SMITHING_TABLE_PATTERN.asItem()) || stack.is(AEItems.STONECUTTING_PATTERN.asItem());
        }
        catch (Exception e) {
            RecursiveAE2PatternProvider.LOGGER.debug("Error checking if item is AE2 pattern: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean isRecursive(ItemStack patternStack) {
        if (patternStack.isEmpty() || !PatternUtil.isAE2Pattern(patternStack)) {
            return false;
        }
        try {
            CustomData customData = (CustomData)patternStack.get(DataComponents.CUSTOM_DATA);
            if (customData != null) {
                CompoundTag tag = customData.copyTag();
                return tag.getBoolean("recursive");
            }
        }
        catch (Exception e) {
            RecursiveAE2PatternProvider.LOGGER.debug("Failed to read recursive flag: {}", (Object)e.getMessage());
        }
        return false;
    }

    public static ItemStack createRecursivePattern(ItemStack originalPattern) {
        try {
            ItemStack newPattern = originalPattern.copy();
            CustomData existingData = (CustomData)newPattern.get(DataComponents.CUSTOM_DATA);
            CompoundTag customData = existingData != null ? existingData.copyTag() : new CompoundTag();
            customData.putBoolean("recursive", true);
            newPattern.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customData));
            return newPattern;
        }
        catch (Exception e) {
            RecursiveAE2PatternProvider.LOGGER.error("Failed to create recursive pattern for JEI: {}", (Object)e.getMessage());
            return originalPattern.copy();
        }
    }
}

