/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.recursiveae2patternprovider.client;

import com.lumengrid.recursiveae2patternprovider.Config;
import com.lumengrid.recursiveae2patternprovider.PatternUtil;
import com.lumengrid.recursiveae2patternprovider.RecursiveAE2PatternProvider;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="recursiveae2patternprovider", value={Dist.CLIENT})
public class TooltipHandler {
    private static String getConfiguredItemDisplayName() {
        try {
            String itemName = (String)Config.RECIPE_ITEM.get();
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            return item.getName(item.getDefaultInstance()).getString();
        }
        catch (Exception e) {
            return Items.IRON_INGOT.getName(Items.IRON_INGOT.getDefaultInstance()).getString();
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (!((Boolean)Config.ENABLE.get()).booleanValue() || (Integer)Config.RECURSION_DEPTH.get() == 0 || !PatternUtil.isAE2Pattern(itemStack)) {
            return;
        }
        boolean isRecursive = PatternUtil.isRecursive(itemStack);
        String configuredItemName = TooltipHandler.getConfiguredItemDisplayName();
        try {
            List tooltip = event.getToolTip();
            if (isRecursive) {
                tooltip.add(Component.empty());
                tooltip.add(Component.literal((String)"\ud83d\udd04 Recursive").withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.ITALIC}));
                tooltip.add(Component.literal((String)"Automatically generates dependency patterns").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                if ((Integer)Config.RECURSION_DEPTH.get() > 0) {
                    tooltip.add(Component.literal((String)("Depth: " + String.valueOf(Config.RECURSION_DEPTH.get()))).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                }
                tooltip.add(Component.empty());
                tooltip.add(Component.literal((String)"Craft alone to remove recursion").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
            } else {
                tooltip.add(Component.empty());
                tooltip.add(Component.literal((String)("Craft with " + configuredItemName + " to make recursive")).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            }
        }
        catch (Exception e) {
            RecursiveAE2PatternProvider.LOGGER.debug("Error adding pattern tooltip: {}", (Object)e.getMessage());
        }
    }
}

