/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.recursiveae2patternprovider.jei;

import appeng.core.definitions.AEItems;
import com.lumengrid.recursiveae2patternprovider.Config;
import com.lumengrid.recursiveae2patternprovider.PatternUtil;
import com.lumengrid.recursiveae2patternprovider.RecursiveAE2PatternProvider;
import com.lumengrid.recursiveae2patternprovider.jei.RecursivePatternRecipeCategory;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class RecursivePatternJEIPlugin
implements IModPlugin {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"recursiveae2patternprovider", (String)"recursive_pattern_recipes");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    private ItemStack getConfiguredRecipeItemStack() {
        try {
            String itemName = (String)Config.RECIPE_ITEM.get();
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            return new ItemStack((ItemLike)item);
        }
        catch (Exception e) {
            RecursiveAE2PatternProvider.LOGGER.warn("Invalid recipe item configured for JEI: '{}', falling back to iron ingot", Config.RECIPE_ITEM.get());
            return new ItemStack((ItemLike)Items.IRON_INGOT);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new RecursivePatternRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ItemStack configuredRecipeItem = this.getConfiguredRecipeItemStack();
        List<RecursivePatternRecipe> recipes = Arrays.asList(new RecursivePatternRecipe(Arrays.asList(AEItems.CRAFTING_PATTERN.stack(), configuredRecipeItem), this.createRecursivePattern(AEItems.CRAFTING_PATTERN.stack()), "Add Recursion"), new RecursivePatternRecipe(Arrays.asList(AEItems.PROCESSING_PATTERN.stack(), configuredRecipeItem.copy()), this.createRecursivePattern(AEItems.PROCESSING_PATTERN.stack()), "Add Recursion"), new RecursivePatternRecipe(Arrays.asList(AEItems.SMITHING_TABLE_PATTERN.stack(), configuredRecipeItem.copy()), this.createRecursivePattern(AEItems.SMITHING_TABLE_PATTERN.stack()), "Add Recursion"), new RecursivePatternRecipe(Arrays.asList(this.createRecursivePattern(AEItems.CRAFTING_PATTERN.stack())), AEItems.CRAFTING_PATTERN.stack(), "Remove Recursion"), new RecursivePatternRecipe(Arrays.asList(this.createRecursivePattern(AEItems.PROCESSING_PATTERN.stack())), AEItems.PROCESSING_PATTERN.stack(), "Remove Recursion"), new RecursivePatternRecipe(Arrays.asList(this.createRecursivePattern(AEItems.SMITHING_TABLE_PATTERN.stack())), AEItems.SMITHING_TABLE_PATTERN.stack(), "Remove Recursion"));
        registration.addRecipes(RecursivePatternRecipeCategory.RECIPE_TYPE, recipes);
    }

    private ItemStack createRecursivePattern(ItemStack originalPattern) {
        ItemStack recursivePattern = originalPattern.copy();
        recursivePattern = PatternUtil.createRecursivePattern(recursivePattern);
        return recursivePattern;
    }

    public static class RecursivePatternRecipe {
        private final List<ItemStack> inputs;
        private final ItemStack output;
        private final String recipeType;

        public RecursivePatternRecipe(List<ItemStack> inputs, ItemStack output, String recipeType) {
            this.inputs = inputs;
            this.output = output;
            this.recipeType = recipeType;
        }

        public List<ItemStack> getInputs() {
            return this.inputs;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public String getRecipeType() {
            return this.recipeType;
        }
    }
}

