/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.recursiveae2patternprovider.mixin;

import appeng.api.crafting.PatternDetailsHelper;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.RestrictedInputSlot;
import com.lumengrid.recursiveae2patternprovider.PatternUtil;
import com.lumengrid.recursiveae2patternprovider.RecursiveAE2PatternProvider;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PatternEncodingTermMenu.class})
public class PatternEncodingTermMenuMixin {
    @Shadow
    private RestrictedInputSlot encodedPatternSlot;

    @Inject(method={"encode"}, at={@At(value="INVOKE", target="Lappeng/menu/slot/RestrictedInputSlot;set(Lnet/minecraft/world/item/ItemStack;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void preserveRecursiveFlag(CallbackInfo ci, ItemStack encodedPattern) {
        try {
            if (encodedPattern == null || encodedPattern.isEmpty()) {
                return;
            }
            ItemStack existingPattern = this.encodedPatternSlot.getItem();
            if (!existingPattern.isEmpty() && PatternDetailsHelper.isEncodedPattern((ItemStack)existingPattern) && PatternUtil.isRecursive(existingPattern)) {
                RecursiveAE2PatternProvider.LOGGER.debug("Preserving recursive flag during pattern re-encoding");
                CustomData existingData = (CustomData)encodedPattern.get(DataComponents.CUSTOM_DATA);
                CompoundTag customData = existingData != null ? existingData.copyTag() : new CompoundTag();
                customData.putBoolean("recursive", true);
                encodedPattern.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customData));
                RecursiveAE2PatternProvider.LOGGER.debug("Successfully preserved recursive flag in re-encoded pattern");
            }
        }
        catch (Exception e) {
            RecursiveAE2PatternProvider.LOGGER.error("Failed to preserve recursive flag during pattern encoding: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

