/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.recursiveae2patternprovider.mixin;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.util.inv.AppEngInternalInventory;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixPattern;
import com.lumengrid.recursiveae2patternprovider.Config;
import com.lumengrid.recursiveae2patternprovider.PatternUtil;
import com.lumengrid.recursiveae2patternprovider.RecursiveAE2PatternProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TileAssemblerMatrixPattern.class})
public class TileAssemblerMatrixPatternMixin {
    @Unique
    private final List<IPatternDetails> recursivePatterns$autoGeneratedPatterns = new ArrayList<IPatternDetails>();
    @Unique
    private final Set<String> recursivePatterns$processedRecipes = new HashSet<String>();
    @Unique
    private final Set<String> recursivePatterns$processedItems = new HashSet<String>();
    @Shadow
    private List<IPatternDetails> patterns;

    @Inject(method={"updatePatterns"}, at={@At(value="RETURN")}, remap=false)
    private void injectDependencyPatterns(CallbackInfo ci) {
        try {
            if (!((Boolean)Config.ENABLE.get()).booleanValue()) {
                return;
            }
            int maxDepth = (Integer)Config.RECURSION_DEPTH.get();
            if (maxDepth == 0) {
                return;
            }
            this.recursivePatterns$processedRecipes.clear();
            this.recursivePatterns$processedItems.clear();
            TileAssemblerMatrixPattern self = (TileAssemblerMatrixPattern)this;
            Level level = self.getLevel();
            if (level == null) {
                return;
            }
            ArrayList<IPatternDetails> recursivePatterns = new ArrayList<IPatternDetails>();
            AppEngInternalInventory patternInventory = self.getPatternInventory();
            for (ItemStack stack : patternInventory) {
                IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)level);
                if (details == null || !PatternUtil.isRecursive(stack)) continue;
                recursivePatterns.add(details);
                RecursiveAE2PatternProvider.LOGGER.debug("Found recursive pattern in Assembler Matrix ({}): {}", (Object)stack.getItem().builtInRegistryHolder().key().location(), (Object)stack.getDisplayName().getString());
            }
            this.recursivePatterns$autoGeneratedPatterns.clear();
            for (IPatternDetails recursivePattern : recursivePatterns) {
                this.recursivePatterns$generateDependencyPatterns(recursivePattern, level, 0, maxDepth);
            }
            this.patterns.addAll(this.recursivePatterns$autoGeneratedPatterns);
            if (!this.recursivePatterns$autoGeneratedPatterns.isEmpty()) {
                RecursiveAE2PatternProvider.LOGGER.info("Generated {} dependency patterns for Assembler Matrix Pattern", (Object)this.recursivePatterns$autoGeneratedPatterns.size());
                ICraftingProvider.requestUpdate((IManagedGridNode)self.getMainNode());
            }
        }
        catch (Exception e) {
            RecursiveAE2PatternProvider.LOGGER.error("Failed to inject dependency patterns for Assembler Matrix: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Unique
    private void recursivePatterns$generateDependencyPatterns(IPatternDetails pattern, Level level, int currentDepth, int maxDepth) {
        if (level == null) {
            return;
        }
        if (maxDepth >= 0 && currentDepth >= maxDepth) {
            return;
        }
        RecipeManager recipeManager = level.getRecipeManager();
        List allRecipes = recipeManager.getAllRecipesFor(RecipeType.CRAFTING);
        for (IPatternDetails.IInput patternInput : pattern.getInputs()) {
            for (GenericStack inputCandidate : patternInput.getPossibleInputs()) {
                try {
                    AEKey key = inputCandidate.what();
                    if (!(key instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)key;
                    ItemStack inputStack = itemKey.toStack();
                    String itemId = inputStack.getItem().toString();
                    if (this.recursivePatterns$processedItems.contains(itemId)) continue;
                    this.recursivePatterns$processedItems.add(itemId);
                    this.recursivePatterns$findAndCreatePatternsForItem(inputStack, allRecipes, level, pattern, currentDepth, maxDepth);
                }
                catch (Exception e) {
                    RecursiveAE2PatternProvider.LOGGER.debug("Error processing input candidate: {}", (Object)e.getMessage());
                }
            }
        }
    }

    @Unique
    private void recursivePatterns$findAndCreatePatternsForItem(ItemStack targetItem, Collection<RecipeHolder<CraftingRecipe>> allRecipes, Level level, IPatternDetails parentPattern, int currentDepth, int maxDepth) {
        for (RecipeHolder<CraftingRecipe> recipe : allRecipes) {
            String recipeId = recipe.id().toString();
            if (this.recursivePatterns$processedRecipes.contains(recipeId)) continue;
            try {
                ItemStack recipeOutput = ((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
                if (recipeOutput.isEmpty() || !recipeOutput.is(targetItem.getItem()) || !ItemStack.isSameItemSameComponents((ItemStack)targetItem, (ItemStack)recipeOutput)) continue;
                this.recursivePatterns$processedRecipes.add(recipeId);
                ItemStack[] inputs = this.recursivePatterns$getRecipeInputsAs3x3Grid((CraftingRecipe)recipe.value());
                ItemStack patternStack = AEItems.CRAFTING_PATTERN.stack();
                boolean allowSubstitutes = (Boolean)Config.DEFAULT_ALLOW_SUBSTITUTES.get();
                boolean allowFluidSubstitutes = (Boolean)Config.DEFAULT_ALLOW_FLUID_SUBSTITUTES.get();
                if (parentPattern instanceof AECraftingPattern) {
                    AECraftingPattern parentCraftingPattern = (AECraftingPattern)parentPattern;
                    allowSubstitutes = parentCraftingPattern.canSubstitute();
                    allowFluidSubstitutes = parentCraftingPattern.canSubstituteFluids();
                }
                AECraftingPattern.encode((ItemStack)patternStack, recipe, (ItemStack[])inputs, (ItemStack)recipeOutput, (boolean)allowSubstitutes, (boolean)allowFluidSubstitutes);
                AECraftingPattern aePattern = new AECraftingPattern(Objects.requireNonNull(AEItemKey.of((ItemStack)patternStack)), level);
                if (aePattern.getOutputs() == null || aePattern.getOutputs().isEmpty()) continue;
                this.recursivePatterns$autoGeneratedPatterns.add((IPatternDetails)aePattern);
                this.recursivePatterns$generateDependencyPatterns((IPatternDetails)aePattern, level, currentDepth + 1, maxDepth);
            }
            catch (Exception e) {
                RecursiveAE2PatternProvider.LOGGER.debug("Failed to create dependency pattern for recipe: {} - {}", (Object)recipe.id(), (Object)e.getMessage());
            }
        }
    }

    @Unique
    private ItemStack[] recursivePatterns$getRecipeInputsAs3x3Grid(CraftingRecipe recipe) {
        Object[] inputs = new ItemStack[9];
        Arrays.fill(inputs, ItemStack.EMPTY);
        NonNullList ingredients = recipe.getIngredients();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            int width = shapedRecipe.getWidth();
            int height = shapedRecipe.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    Ingredient ingredient;
                    int ingredientIndex = y * width + x;
                    int gridIndex = y * 3 + x;
                    if (ingredientIndex >= ingredients.size() || (ingredient = (Ingredient)ingredients.get(ingredientIndex)).isEmpty() || ingredient.getItems().length <= 0) continue;
                    inputs[gridIndex] = ingredient.getItems()[0].copy();
                }
            }
        } else {
            int index = 0;
            for (Ingredient ingredient : ingredients) {
                if (ingredient.isEmpty() || ingredient.getItems().length <= 0 || index >= 9) continue;
                inputs[index] = ingredient.getItems()[0].copy();
                ++index;
            }
        }
        return inputs;
    }
}

