/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.recursiveae2patternprovider.recipe;

import appeng.core.definitions.AEItems;
import com.lumengrid.recursiveae2patternprovider.Config;
import com.lumengrid.recursiveae2patternprovider.PatternUtil;
import com.lumengrid.recursiveae2patternprovider.RecursiveAE2PatternProvider;
import com.lumengrid.recursiveae2patternprovider.recipe.RecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RecursivePatternRecipe
implements CraftingRecipe {
    private Item getConfiguredRecipeItem() {
        try {
            String itemName = (String)Config.RECIPE_ITEM.get();
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            return (Item)BuiltInRegistries.ITEM.get(itemId);
        }
        catch (Exception e) {
            RecursiveAE2PatternProvider.LOGGER.warn("Invalid recipe item configured: '{}', falling back to iron ingot", Config.RECIPE_ITEM.get());
            return Items.IRON_INGOT;
        }
    }

    public boolean matches(CraftingInput input, Level level) {
        ItemStack pattern = ItemStack.EMPTY;
        ItemStack recipeItem = ItemStack.EMPTY;
        int itemCount = 0;
        Item configuredItem = this.getConfiguredRecipeItem();
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            ++itemCount;
            if (PatternUtil.isAE2Pattern(stack)) {
                pattern = stack;
                RecursiveAE2PatternProvider.LOGGER.debug("Found AE2 pattern in recipe: {}", (Object)stack.getItem().builtInRegistryHolder().key().location());
                continue;
            }
            if (!stack.is(configuredItem)) continue;
            recipeItem = stack;
        }
        if (!(itemCount != 2 || pattern.isEmpty() || recipeItem.isEmpty() || PatternUtil.isRecursive(pattern))) {
            return true;
        }
        return itemCount == 1 && !pattern.isEmpty() && PatternUtil.isRecursive(pattern);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack pattern = ItemStack.EMPTY;
        boolean hasRecipeItem = false;
        int itemCount = 0;
        Item configuredItem = this.getConfiguredRecipeItem();
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            ++itemCount;
            if (PatternUtil.isAE2Pattern(stack)) {
                pattern = stack;
                continue;
            }
            if (!stack.is(configuredItem)) continue;
            hasRecipeItem = true;
        }
        if (!pattern.isEmpty()) {
            if (itemCount == 2 && hasRecipeItem) {
                RecursiveAE2PatternProvider.LOGGER.debug("Adding recursive flag to: {}", (Object)pattern.getItem().builtInRegistryHolder().key().location());
                return this.createRecursivePattern(pattern);
            }
            if (itemCount == 1 && PatternUtil.isRecursive(pattern)) {
                RecursiveAE2PatternProvider.LOGGER.debug("Removing recursive flag from: {}", (Object)pattern.getItem().builtInRegistryHolder().key().location());
                return this.removeRecursiveFlag(pattern);
            }
        }
        return ItemStack.EMPTY;
    }

    private ItemStack createRecursivePattern(ItemStack originalPattern) {
        try {
            ItemStack newPattern = originalPattern.copy();
            CustomData existingData = (CustomData)newPattern.get(DataComponents.CUSTOM_DATA);
            CompoundTag customData = existingData != null ? existingData.copyTag() : new CompoundTag();
            customData.putBoolean("recursive", true);
            newPattern.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customData));
            RecursiveAE2PatternProvider.LOGGER.debug("Created recursive pattern with NBT: {}", (Object)customData);
            return newPattern;
        }
        catch (Exception e) {
            RecursiveAE2PatternProvider.LOGGER.error("Failed to create recursive pattern: {}", (Object)e.getMessage());
            return ItemStack.EMPTY;
        }
    }

    private ItemStack removeRecursiveFlag(ItemStack recursivePattern) {
        try {
            ItemStack newPattern = recursivePattern.copy();
            CustomData existingData = (CustomData)newPattern.get(DataComponents.CUSTOM_DATA);
            if (existingData != null) {
                CompoundTag customData = existingData.copyTag();
                customData.remove("recursive");
                if (customData.isEmpty()) {
                    newPattern.remove(DataComponents.CUSTOM_DATA);
                    RecursiveAE2PatternProvider.LOGGER.debug("Removed all custom data from pattern");
                } else {
                    newPattern.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customData));
                    RecursiveAE2PatternProvider.LOGGER.debug("Removed recursive flag, remaining NBT: {}", (Object)customData);
                }
            }
            return newPattern;
        }
        catch (Exception e) {
            RecursiveAE2PatternProvider.LOGGER.error("Failed to remove recursive flag: {}", (Object)e.getMessage());
            return ItemStack.EMPTY;
        }
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return AEItems.CRAFTING_PATTERN.stack();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        return NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.RECURSIVE_PATTERN_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }
}

