/*
 * Decompiled with CFR 0.152.
 */
package org.dev;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class LookAt
implements ClientModInitializer {
    private static final File FILE = new File("config/locations.json");
    private static final File parentDir = FILE.getParentFile();
    private static final Map<String, float[]> locations = new HashMap<String, float[]>();
    private static final Gson gson = new Gson();
    private boolean turnup = true;
    private final ClientTickEvents.EndTick rotationHandler = this::handleRotationTick;
    private int delay;
    private boolean rotateDelayFlag = false;

    public void onInitializeClient() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> this.locations());
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                float x = FloatArgumentType.getFloat((CommandContext)context, (String)"x");
                float y = FloatArgumentType.getFloat((CommandContext)context, (String)"y");
                this.add(name, x, y);
                return 1;
            })))));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"locations").executes(context -> {
                this.locations();
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"look").then(ClientCommandManager.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)-180.0f, (float)180.0f)).then(ClientCommandManager.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)-90.0f, (float)90.0f)).executes(context -> {
                float x = FloatArgumentType.getFloat((CommandContext)context, (String)"x");
                float y = FloatArgumentType.getFloat((CommandContext)context, (String)"y");
                this.rotatePlayer(x, y);
                return 1;
            }))));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"look").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                if (locations.containsKey(name)) {
                    float[] coords = locations.get(name);
                    this.rotatePlayer(coords[0], coords[1]);
                } else {
                    this.sendMessageToPlayer("message.lookat.not_found", name);
                }
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                this.remove(name);
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"toggleturnup").executes(context -> {
                this.turnup = !this.turnup;
                this.saveLocations();
                if (this.turnup) {
                    this.sendMessageToPlayer("message.lookat.turnupon", new Object[0]);
                } else {
                    this.sendMessageToPlayer("message.lookat.turnupoff", new Object[0]);
                }
                return 1;
            }));
        });
    }

    private void handleRotationTick(class_310 client) {
        if (!this.rotateDelayFlag) {
            return;
        }
        if (this.delay > 0) {
            --this.delay;
        } else {
            if (client.field_1724 != null) {
                client.field_1724.method_36457(-90.0f);
            }
            this.rotateDelayFlag = false;
        }
    }

    private void rotatePlayer(float x, float y) {
        class_310 client = class_310.method_1551();
        this.delay = 50;
        if (client.field_1724 == null) {
            return;
        }
        client.field_1724.method_36456(x);
        client.field_1724.method_36457(y);
        if (this.turnup) {
            this.rotateDelayFlag = true;
            ClientTickEvents.END_CLIENT_TICK.register((Object)this.rotationHandler);
        }
    }

    public void locations() {
        if (FILE.exists()) {
            try (FileReader reader = new FileReader(FILE);){
                JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                if (jsonElement.isJsonObject()) {
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    if (jsonObject.has("locations")) {
                        Type locationsType = new TypeToken<Map<String, float[]>>(this){}.getType();
                        Map loadedLocations = (Map)gson.fromJson(jsonObject.get("locations"), locationsType);
                        if (loadedLocations != null && !loadedLocations.isEmpty()) {
                            locations.putAll(loadedLocations);
                            StringBuilder message = new StringBuilder();
                            for (Map.Entry<String, float[]> entry : locations.entrySet()) {
                                message.append("\n").append(entry.getKey()).append(": X=").append(entry.getValue()[0]).append(", Y=").append(entry.getValue()[1]);
                            }
                            this.sendMessageToPlayer("message.lookat.locations", new Object[0]);
                            this.sendMessageToPlayer(message.toString(), new Object[0]);
                        } else {
                            this.sendMessageToPlayer("message.lookat.empty", new Object[0]);
                        }
                    } else {
                        this.addFileVar("locations", new HashMap());
                    }
                    if (jsonObject.has("turnup")) {
                        try {
                            this.turnup = jsonObject.get("turnup").getAsBoolean();
                        }
                        catch (Exception e) {
                            this.turnup = true;
                        }
                    } else {
                        this.addFileVar("turnup", true);
                    }
                } else {
                    this.sendMessageToPlayer("message.lookat.file_invalid", new Object[0]);
                }
            }
            catch (IOException e) {
                this.sendMessageToPlayer("message.lookat.failed_to_load", new Object[0]);
            }
        } else {
            this.createFile();
        }
    }

    private void addFileVar(String key, Object value) {
        try {
            if (!FILE.exists()) {
                this.createFile();
            }
            JsonObject json = JsonParser.parseReader((Reader)new FileReader(FILE)).getAsJsonObject();
            if (value instanceof Boolean) {
                json.addProperty(key, (Boolean)value);
            } else if (value instanceof Map) {
                json.add(key, gson.toJsonTree(value));
            }
            try (FileWriter writer = new FileWriter(FILE);){
                gson.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (Exception e) {
            this.sendMessageToPlayer("message.lookat.error_working_with_file", new Object[0]);
        }
    }

    private void createFile() {
        try {
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
                FILE.createNewFile();
            }
            try (FileWriter writer = new FileWriter(FILE);){
                HashMap<String, Serializable> data = new HashMap<String, Serializable>();
                data.put("turnup", Boolean.valueOf(true));
                data.put("locations", new HashMap());
                gson.toJson(data, (Appendable)writer);
            }
            this.sendMessageToPlayer("message.lookat.empty", new Object[0]);
        }
        catch (IOException e) {
            this.sendMessageToPlayer("message.lookat.failed_to_create", new Object[0]);
            System.err.println("Error with file creation for lookat mod: " + e.getMessage());
        }
    }

    private void remove(String name) {
        if (locations.containsKey(name)) {
            locations.remove(name);
            if (this.saveLocations()) {
                this.sendMessageToPlayer("message.lookat.removed", name);
            }
        } else {
            this.sendMessageToPlayer("message.lookat.not_found", name);
        }
    }

    private void add(String name, float x, float y) {
        try {
            JsonObject json;
            if (!FILE.exists()) {
                this.createFile();
            }
            if ((json = JsonParser.parseReader((Reader)new FileReader(FILE)).getAsJsonObject()).has("locations")) {
                Type locationsType = new TypeToken<Map<String, float[]>>(this){}.getType();
                Map loadedLocations = (Map)gson.fromJson(json.get("locations"), locationsType);
                locations.putAll(loadedLocations);
            } else {
                this.addFileVar("locations", new HashMap());
            }
            float[] coords = new float[]{x, y};
            locations.put(name, coords);
            if (this.saveLocations()) {
                this.sendMessageToPlayer("message.lookat.added", name, Float.valueOf(x), Float.valueOf(y));
            }
        }
        catch (Exception e) {
            this.sendMessageToPlayer("message.lookat.error_working_with_file", new Object[0]);
        }
    }

    private boolean saveLocations() {
        boolean bl;
        FileWriter writer = new FileWriter(FILE);
        try {
            JsonObject root = new JsonObject();
            JsonObject locationsObj = new JsonObject();
            for (Map.Entry<String, float[]> entry : locations.entrySet()) {
                JsonArray coords = new JsonArray();
                coords.add((Number)Float.valueOf(entry.getValue()[0]));
                coords.add((Number)Float.valueOf(entry.getValue()[1]));
                locationsObj.add(entry.getKey(), (JsonElement)coords);
            }
            root.add("locations", (JsonElement)locationsObj);
            root.addProperty("turnup", Boolean.valueOf(this.turnup));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((JsonElement)root, (Appendable)writer);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.sendMessageToPlayer("message.lookat.failed_to_save", new Object[0]);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    private void sendMessageToPlayer(String message, Object ... args) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43469((String)message, (Object[])args), false);
        } else {
            System.out.println("message.lookat.player_not_found");
        }
    }
}

