# Selects a random chunk nearby, and calls swap_chunk if no one is looking at it.
# inputs: as @s[type=player]
# outputs: none

# Get player chunk position
execute store result score targetX impermanence_vars run data get entity @s Pos[0]
execute store result score targetZ impermanence_vars run data get entity @s Pos[2]
scoreboard players operation targetX impermanence_vars /= 16 impermanence_vars
scoreboard players operation targetZ impermanence_vars /= 16 impermanence_vars

# Get random nearby chunk position
execute store result score offsetX impermanence_vars run random value -3..3
execute store result score offsetZ impermanence_vars run random value -3..3
scoreboard players operation targetX impermanence_vars += offsetX impermanence_vars
scoreboard players operation targetZ impermanence_vars += offsetZ impermanence_vars

# Convert to block position
scoreboard players operation targetX impermanence_vars *= 16 impermanence_vars
scoreboard players operation targetZ impermanence_vars *= 16 impermanence_vars

# Create a marker there
summon marker ~ ~ ~ {Tags:["targetlocation"]}
execute as @e[tag=targetlocation] store result entity @s Pos[0] double 1 run scoreboard players get targetX impermanence_vars
execute as @e[tag=targetlocation] store result entity @s Pos[2] double 1 run scoreboard players get targetZ impermanence_vars

# Find if any players are looking at this location
scoreboard players set isInvalid impermanence_vars 0
execute as @a[distance=0..512] at @s rotated as @s run function impermanence:_check_looking

execute as @e[tag=targetlocation] at @s run tp @s ~16 ~ ~
execute as @a[distance=0..512] at @s rotated as @s run function impermanence:_check_looking

execute as @e[tag=targetlocation] at @s run tp @s ~ ~ ~16
execute as @a[distance=0..512] at @s rotated as @s run function impermanence:_check_looking

execute as @e[tag=targetlocation] at @s run tp @s ~-16 ~ ~
execute as @a[distance=0..512] at @s rotated as @s run function impermanence:_check_looking

# Swap chunk if no one is looking
execute if score isInvalid impermanence_vars < 1 impermanence_vars at @e[tag=targetlocation] run function impermanence:swap_chunk

# Cleanup
kill @e[tag=targetlocation]
