# Gets a random chunk from storage and copies it to the overworld.
# inputs: positioned ~ ~ ~
# outputs: none

# Get 'from' position
execute store result score targetX impermanence_vars run random value 0..2
execute store result score targetZ impermanence_vars run random value 0..2
scoreboard players operation targetX impermanence_vars *= 16 impermanence_vars
scoreboard players operation targetZ impermanence_vars *= 16 impermanence_vars

# Save 'from' position
data modify storage impermanence:inputs copy_whole_chunk.from_dimension set value "impermanence:storage"
execute store result storage impermanence:inputs copy_whole_chunk.from_x int 1 run scoreboard players get targetX impermanence_vars
execute store result storage impermanence:inputs copy_whole_chunk.from_z int 1 run scoreboard players get targetZ impermanence_vars

# 'From' position + 15
scoreboard players operation targetX impermanence_vars += 15 impermanence_vars
scoreboard players operation targetZ impermanence_vars += 15 impermanence_vars
execute store result storage impermanence:inputs copy_whole_chunk.from_x_plus_fifteen int 1 run scoreboard players get targetX impermanence_vars
execute store result storage impermanence:inputs copy_whole_chunk.from_z_plus_fifteen int 1 run scoreboard players get targetZ impermanence_vars

# Get 'to' position
summon marker ~ ~ ~ {Tags:["chunk_pos"]}
execute store result score targetX impermanence_vars run data get entity @e[tag=chunk_pos,limit=1] Pos[0]
execute store result score targetZ impermanence_vars run data get entity @e[tag=chunk_pos,limit=1] Pos[2]
kill @e[tag=chunk_pos]
scoreboard players operation targetX impermanence_vars /= 16 impermanence_vars
scoreboard players operation targetZ impermanence_vars /= 16 impermanence_vars
scoreboard players operation targetX impermanence_vars *= 16 impermanence_vars
scoreboard players operation targetZ impermanence_vars *= 16 impermanence_vars

# Save 'to' position
data modify storage impermanence:inputs copy_whole_chunk.to_dimension set value "minecraft:overworld"
execute store result storage impermanence:inputs copy_whole_chunk.to_x int 1 run scoreboard players get targetX impermanence_vars
execute store result storage impermanence:inputs copy_whole_chunk.to_z int 1 run scoreboard players get targetZ impermanence_vars

# Copy chunk!
function impermanence:copy_whole_chunk with storage impermanence:inputs copy_whole_chunk
