/*
 * Decompiled with CFR 0.152.
 */
package com.baranhan123.anointeditems.blocks;

import com.baranhan123.anointeditems.blocks.ModBlocks;
import com.baranhan123.anointeditems.config.Common;
import com.baranhan123.anointeditems.items.GemItem;
import com.baranhan123.anointeditems.items.ItemList;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class AnointingTableContainer
extends ItemCombinerMenu {
    public AnointingTableContainer(int id, Inventory playerInv, ContainerLevelAccess worldPosCallable) {
        super(ModBlocks.ANOINTING_TABLE_CONTAINER, id, playerInv, worldPosCallable);
    }

    protected boolean m_6560_(Player player, boolean hasStack) {
        return true;
    }

    protected boolean m_8039_(BlockState state) {
        return state.m_60713_((Block)ModBlocks.ANOINTING_TABLE);
    }

    private boolean isWolfArmor(ItemStack stack) {
        return ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString().contains("wolf_armor");
    }

    public boolean isValidOrEmpty() {
        ItemStack slot0 = this.f_39769_.m_8020_(0);
        ItemStack slot1 = this.f_39769_.m_8020_(1);
        boolean isValidItem = slot0.m_41720_() instanceof ArmorItem || slot0.m_41720_() instanceof DiggerItem || slot0.m_41720_() instanceof SwordItem || slot0.m_41720_() instanceof ShieldItem || this.isWolfArmor(slot0) || slot0.m_41720_() instanceof BowItem || slot0.m_41720_() instanceof CrossbowItem;
        boolean isValidGem = slot1.m_41720_() instanceof GemItem;
        return isValidItem && isValidGem || slot0.m_41619_() && slot1.m_41619_();
    }

    public void m_6640_() {
        ItemStack itemStack = this.f_39769_.m_8020_(0);
        ItemStack gemStack = this.f_39769_.m_8020_(1);
        if ((itemStack.m_41720_() instanceof ArmorItem || itemStack.m_41720_() instanceof DiggerItem || itemStack.m_41720_() instanceof SwordItem || itemStack.m_41720_() instanceof ShieldItem || itemStack.m_41720_() instanceof BowItem || itemStack.m_41720_() instanceof CrossbowItem || this.isWolfArmor(itemStack)) && itemStack.m_41784_().m_128451_("anointeditemstier") < 4) {
            ItemStack newStack = itemStack.m_41777_();
            boolean applied = false;
            if (gemStack.m_41720_().equals(ItemList.power_oil)) {
                this.doDefaultStuff(newStack);
                this.addToTag(newStack, "attackDamage", (Double)Common.powerIncrement.get(), "attackDamageUUID");
                applied = true;
            } else if (gemStack.m_41720_().equals(ItemList.agility_oil)) {
                this.doDefaultStuff(newStack);
                this.addToTag(newStack, "speed", (Double)Common.agilityIncrement.get(), "speedUUID");
                applied = true;
            } else if (gemStack.m_41720_().equals(ItemList.tenacity_oil)) {
                this.doDefaultStuff(newStack);
                this.addToTag(newStack, "health", (Double)Common.tenacityIncrement.get(), "healthUUID");
                applied = true;
            } else if (gemStack.m_41720_().equals(ItemList.protection_oil)) {
                this.doDefaultStuff(newStack);
                this.addToTag(newStack, "armor", (Double)Common.protectionIncrement.get(), "armorUUID");
                applied = true;
            } else if (gemStack.m_41720_().equals(ItemList.lightness_oil)) {
                this.doDefaultStuff(newStack);
                this.addToTag(newStack, "attackSpeed", (Double)Common.lightnessIncrement.get(), "attackSpeedUUID");
                applied = true;
            } else if (gemStack.m_41720_().equals(ItemList.acceleration_oil)) {
                this.doDefaultStuff(newStack);
                this.addToTag(newStack, "miningSpeed", (Double)Common.accelerationIncrement.get(), "miningSpeedUUID");
                applied = true;
            }
            if (applied) {
                this.f_39768_.m_6836_(0, newStack);
            }
        }
    }

    protected ItemCombinerMenuSlotDefinition m_266183_() {
        return ItemCombinerMenuSlotDefinition.m_266303_().m_266197_(0, 27, 47, stack -> true).m_266197_(1, 76, 47, stack -> true).m_266198_(2, 134, 47).m_266441_();
    }

    private void addToTag(ItemStack stack, String statKey, double amount, String uuidKey) {
        stack.m_41784_().m_128347_("anointeditems" + statKey, stack.m_41784_().m_128459_("anointeditems" + statKey) + amount);
        if (stack.m_41784_().m_128461_("anointeditems" + uuidKey).isEmpty()) {
            stack.m_41784_().m_128359_("anointeditems" + uuidKey, UUID.randomUUID().toString());
        }
    }

    protected void m_142365_(Player player, ItemStack stack) {
        this.f_39769_.m_8020_(0).m_41774_(1);
        this.f_39769_.m_8020_(1).m_41774_(1);
        this.f_39770_.m_39292_((level, pos) -> level.m_5594_(null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.0f));
    }

    private boolean hasInputItem() {
        return !this.f_39769_.m_8020_(0).m_41619_();
    }

    private boolean hasInputMaterial() {
        return !this.f_39769_.m_8020_(1).m_41619_();
    }

    public static void nameItem(ItemStack stack) {
        String str = AnointingTableContainer.getTierColor(stack) + stack.m_41784_().m_128461_("anointeditemsdefaultName");
        stack.m_41784_().m_128359_("anointeditemscoloredName", str);
        stack.m_41714_((Component)Component.m_237113_((String)str));
    }

    public static String getTierColor(ItemStack stack) {
        int tier = stack.m_41784_().m_128451_("anointeditemstier");
        if (tier == 1) {
            return String.valueOf(ChatFormatting.GREEN);
        }
        if (tier == 2) {
            return String.valueOf(ChatFormatting.AQUA);
        }
        if (tier == 3) {
            return String.valueOf(ChatFormatting.LIGHT_PURPLE);
        }
        if (tier == 4) {
            return String.valueOf(ChatFormatting.GOLD);
        }
        return String.valueOf(ChatFormatting.GOLD);
    }

    public void doDefaultStuff(ItemStack stack) {
        if (stack.m_41784_().m_128451_("anointeditemstier") == 0) {
            stack.m_41784_().m_128359_("anointeditemsdefaultName", stack.m_41786_().getString());
        }
        stack.m_41784_().m_128405_("anointeditemstier", stack.m_41784_().m_128451_("anointeditemstier") + 1);
        AnointingTableContainer.nameItem(stack);
    }
}

