/*
 * Decompiled with CFR 0.152.
 */
package com.baranhan123.anointeditems.handlers;

import com.baranhan123.anointeditems.blocks.AnointingTableContainer;
import com.baranhan123.anointeditems.networking.InformClient;
import com.baranhan123.anointeditems.networking.Networking;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class EventHandler {
    @SubscribeEvent
    public void breakEvent(PlayerEvent.BreakSpeed e) {
        if (e.getEntity().getPersistentData().m_128441_("anointeditemsminingSpeed")) {
            float value = (float)e.getEntity().getPersistentData().m_128459_("anointeditemsminingSpeed");
            e.setNewSpeed(e.getOriginalSpeed() + value);
        }
    }

    @SubscribeEvent
    public void tickEvent(LivingEvent.LivingTickEvent e) {
        if (e.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity entity = e.getEntity();
        this.handleSlot(entity, EquipmentSlot.HEAD, "helmet", "onHead", item -> true);
        this.handleSlot(entity, EquipmentSlot.CHEST, "chestplate", "onChest", item -> true);
        this.handleSlot(entity, EquipmentSlot.LEGS, "leggings", "onLegs", item -> true);
        this.handleSlot(entity, EquipmentSlot.FEET, "boots", "onFeet", item -> true);
        this.handleSlot(entity, EquipmentSlot.MAINHAND, "mainhand", "onMainhand", stack -> stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof BowItem || stack.m_41720_() instanceof CrossbowItem);
        this.handleSlot(entity, EquipmentSlot.OFFHAND, "offhand", "onOffhand", stack -> stack.m_41720_() instanceof ShieldItem);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.f_19797_ % 20 == 0) {
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)entity), (Object)new InformClient(entity.getPersistentData().m_128459_("anointeditemsminingSpeed")));
            }
            for (ItemStack stack2 : player.m_150109_().f_35974_) {
                if (!stack2.m_41782_() || stack2.m_41783_().m_128451_("anointeditemstier") <= 0 || stack2.m_41786_().getString().equalsIgnoreCase(stack2.m_41783_().m_128461_("anointeditemscoloredName"))) continue;
                stack2.m_41783_().m_128359_("anointeditemsdefaultName", stack2.m_41786_().getString());
                AnointingTableContainer.nameItem(stack2);
            }
        }
    }

    private void handleSlot(LivingEntity entity, EquipmentSlot slot, String prefix, String flagKey, Predicate<ItemStack> validItemCheck) {
        ItemStack stack = entity.m_6844_(slot);
        boolean hasTier = stack.m_41782_() && stack.m_41783_().m_128451_("anointeditemstier") > 0;
        boolean isValidType = validItemCheck.test(stack);
        boolean isApplied = entity.getPersistentData().m_128471_("anointeditems" + flagKey);
        if (!stack.m_41619_() && hasTier && isValidType) {
            if (!isApplied) {
                this.applyModifiers(entity, stack, prefix, flagKey);
            } else if (this.shouldUpdate(entity, stack, prefix)) {
                this.removeModifiers(entity, prefix, flagKey);
                this.applyModifiers(entity, stack, prefix, flagKey);
            }
        } else if (isApplied) {
            this.removeModifiers(entity, prefix, flagKey);
        }
    }

    private void applyModifiers(LivingEntity entity, ItemStack stack, String prefix, String flagKey) {
        entity.getPersistentData().m_128379_("anointeditems" + flagKey, true);
        CompoundTag tag = stack.m_41783_();
        this.addAttribute(entity, Attributes.f_22281_, tag, prefix, "attackDamage");
        this.addAttribute(entity, Attributes.f_22276_, tag, prefix, "health");
        this.addAttribute(entity, Attributes.f_22284_, tag, prefix, "armor");
        this.addAttribute(entity, Attributes.f_22279_, tag, prefix, "speed");
        this.addAttribute(entity, Attributes.f_22283_, tag, prefix, "attackSpeed");
        String miningUUIDKey = "anointeditemsminingSpeedUUID";
        if (!tag.m_128461_(miningUUIDKey).isEmpty()) {
            double value = tag.m_128459_("anointeditemsminingSpeed");
            entity.getPersistentData().m_128347_("anointeditemsminingSpeed", entity.getPersistentData().m_128459_("anointeditemsminingSpeed") + value);
            entity.getPersistentData().m_128347_("anointeditems" + prefix + "MiningSpeed", value);
            entity.getPersistentData().m_128359_("anointeditems" + prefix + "MiningSpeedUUID", tag.m_128461_(miningUUIDKey));
        }
    }

    private void removeModifiers(LivingEntity entity, String prefix, String flagKey) {
        entity.getPersistentData().m_128379_("anointeditems" + flagKey, false);
        this.removeAttribute(entity, Attributes.f_22281_, prefix, "attackDamage");
        if (!entity.getPersistentData().m_128461_("anointeditems" + prefix + "HealthUUID").isEmpty()) {
            try {
                UUID id = UUID.fromString(entity.getPersistentData().m_128461_("anointeditems" + prefix + "HealthUUID"));
                AttributeModifier mod = entity.m_21051_(Attributes.f_22276_).m_22111_(id);
                if (mod != null) {
                    double amount = mod.m_22218_();
                    entity.m_21051_(Attributes.f_22276_).m_22120_(id);
                    entity.m_6469_(entity.m_269291_().m_269264_(), (float)amount);
                }
            }
            catch (Exception id) {
                // empty catch block
            }
            entity.getPersistentData().m_128359_("anointeditems" + prefix + "HealthUUID", "");
        }
        this.removeAttribute(entity, Attributes.f_22284_, prefix, "armor");
        this.removeAttribute(entity, Attributes.f_22279_, prefix, "speed");
        this.removeAttribute(entity, Attributes.f_22283_, prefix, "attackSpeed");
        if (!entity.getPersistentData().m_128461_("anointeditems" + prefix + "MiningSpeedUUID").isEmpty()) {
            double current = entity.getPersistentData().m_128459_("anointeditemsminingSpeed");
            double toRemove = entity.getPersistentData().m_128459_("anointeditems" + prefix + "MiningSpeed");
            entity.getPersistentData().m_128347_("anointeditemsminingSpeed", Math.max(0.0, current - toRemove));
            entity.getPersistentData().m_128347_("anointeditems" + prefix + "MiningSpeed", 0.0);
            entity.getPersistentData().m_128359_("anointeditems" + prefix + "MiningSpeedUUID", "");
        }
    }

    private void addAttribute(LivingEntity entity, Attribute attr, CompoundTag tag, String prefix, String shortKey) {
        String uuidKey = "anointeditems" + shortKey + "UUID";
        if (!tag.m_128461_(uuidKey).isEmpty()) {
            UUID id = UUID.fromString(tag.m_128461_(uuidKey));
            double value = tag.m_128459_("anointeditems" + shortKey);
            if (entity.m_21051_(attr) != null) {
                AttributeModifier mod = new AttributeModifier(id, attr.m_22087_(), value, AttributeModifier.Operation.ADDITION);
                if (!entity.m_21051_(attr).m_22109_(mod)) {
                    entity.m_21051_(attr).m_22118_(mod);
                }
            }
            entity.getPersistentData().m_128359_("anointeditems" + prefix + shortKey.substring(0, 1).toUpperCase() + shortKey.substring(1) + "UUID", tag.m_128461_(uuidKey));
        }
    }

    private void removeAttribute(LivingEntity entity, Attribute attr, String prefix, String shortKey) {
        String pKey = "anointeditems" + prefix + shortKey.substring(0, 1).toUpperCase() + shortKey.substring(1) + "UUID";
        String uuidStr = entity.getPersistentData().m_128461_(pKey);
        if (!uuidStr.isEmpty()) {
            if (entity.m_21051_(attr) != null) {
                entity.m_21051_(attr).m_22120_(UUID.fromString(uuidStr));
            }
            entity.getPersistentData().m_128359_(pKey, "");
        }
    }

    private boolean shouldUpdate(LivingEntity entity, ItemStack stack, String prefix) {
        String currentUUID;
        String storedUUID = entity.getPersistentData().m_128461_("anointeditems" + prefix + "AttackDamageUUID");
        return !storedUUID.equals(currentUUID = stack.m_41783_().m_128461_("anointeditemsattackDamageUUID"));
    }

    @SubscribeEvent
    public void onLoggingIn(PlayerEvent.PlayerLoggedInEvent e) {
        String[] flags;
        Player player = e.getEntity();
        for (String flag : flags = new String[]{"onHead", "onChest", "onLegs", "onFeet", "onMainhand", "onOffhand"}) {
            player.getPersistentData().m_128379_("anointeditems" + flag, false);
        }
    }
}

