package com.buuz135.findme.network;

import com.buuz135.findme.FindMeMod;
import com.buuz135.findme.tracking.TrackingList;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class PositionRequestMessage {

    private class_1799 stack;

    public PositionRequestMessage(class_1799 stack) {
        this.stack = stack;
        TrackingList.trackItem(stack);
    }

    public PositionRequestMessage() {
    }

    public static List<class_2338> getBlockPosInAABB(class_238 axisAlignedBB) {
        List<class_2338> blocks = new ArrayList<class_2338>();
        for (double y = axisAlignedBB.field_1322; y < axisAlignedBB.field_1325; ++y) {
            for (double x = axisAlignedBB.field_1323; x < axisAlignedBB.field_1320; ++x) {
                for (double z = axisAlignedBB.field_1321; z < axisAlignedBB.field_1324; ++z) {
                    blocks.add(new class_2338((int) x, (int) y, (int) z));
                }
            }
        }
        return blocks;
    }

    public PositionRequestMessage fromBytes(ByteBuf buf) {
        class_2540 packetBuffer = new class_2540(buf);
        stack = class_1799.field_8037;
        stack = packetBuffer.method_10819();
        return this;
    }

    public void toBytes(ByteBuf buf) {
        class_2540 packetBuffer = new class_2540(buf);
        packetBuffer.method_10793(stack);
    }

    public static boolean compareItems(class_1799 first, class_1799 second) {
        if (FindMeMod.CONFIG.COMMON.IGNORE_ITEM_DAMAGE)
            return class_1799.method_7984(first, second);
        return class_1799.method_31577(first, second);
    }

    public void handle(Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            class_238 box = new class_238(contextSupplier.get().getPlayer().method_24515()).method_1014(FindMeMod.CONFIG.COMMON.RADIUS_RANGE);
            List<class_2338> blockPosList = new ArrayList<>();
            for (class_2338 blockPos : getBlockPosInAABB(box)) {
                class_2586 tileEntity = contextSupplier.get().getPlayer().method_37908().method_8321(blockPos);
                if (tileEntity != null && FindMeMod.BLOCK_CHECKERS.stream().anyMatch(predicate -> predicate.test(tileEntity, stack))) {
                    blockPosList.add(blockPos);
                }
            }
            if (!blockPosList.isEmpty())
                FindMeMod.CHANNEL.sendToPlayer((class_3222) contextSupplier.get().getPlayer(),new PositionResponseMessage(blockPosList));

        });
        //contextSupplier.get().setPacketHandled(true);
    }

}
