package com.buuz135.findme.network;


import com.buuz135.findme.FindMeMod;
import com.buuz135.findme.client.ClientTickHandler;
import com.buuz135.findme.tracking.TrackingList;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class PositionResponseMessage implements Serializable {

    private List<class_2338> positions;

    public PositionResponseMessage(List<class_2338> positions) {
        this.positions = positions;
    }

    public PositionResponseMessage() {
    }

    public PositionResponseMessage fromBytes(ByteBuf buf) {
        class_2540 packetBuffer = new class_2540(buf);
        int amount = packetBuffer.readInt();
        positions = new ArrayList<>();
        while (amount > 0) {
            positions.add(packetBuffer.method_10811());
            --amount;
        }
        return this;
    }

    public void toBytes(ByteBuf buf) {
        class_2540 packetBuffer = new class_2540(buf);
        packetBuffer.writeInt(positions.size());
        for (class_2338 position : positions) {
            packetBuffer.method_10807(position);
        }
    }

    public void handle(Supplier<NetworkManager.PacketContext> context) {
        class_310.method_1551().execute(() -> {
            if (positions.size() > 0) {
                class_310.method_1551().field_1724.method_7346();
                if (FindMeMod.CONFIG.CLIENT.CONTAINER_TRACKING) {
                    TrackingList.beginTracking();
                    ClientTickHandler.addRunnable(TrackingList::clear, FindMeMod.CONFIG.CLIENT.CONTAINER_TRACK_TIME);
                }
                for (class_2338 position : positions) {
                    for (int i = 0; i < 2; ++i)
                        addParticle(position);
                }
            }
        });
        //context.get().setPacketHandled(true);
    }

    @Environment(EnvType.CLIENT)
    public void addParticle(class_2338 position) {
        class_310.method_1551().field_1724.method_37908().method_8406((class_2394) FindMeMod.FINDME.get(), position.method_10263() + 0.75 - class_310.method_1551().field_1724.method_37908().field_9229.method_43058() / 2D, position.method_10264() + 0.75 - class_310.method_1551().field_1724.method_37908().field_9229.method_43058() / 2D, position.method_10260() + 0.75 - class_310.method_1551().field_1724.method_37908().field_9229.method_43058() / 2D, 0, 0, 0);
        //Minecraft.getInstance().particleEngine.add(new AshParticle((ClientLevel) Minecraft.getInstance().player.level, position.getX() + 0.75 - Minecraft.getInstance().player.level.random.nextDouble() / 2D, position.getY() + 0.75 - Minecraft.getInstance().player.level.random.nextDouble() / 2D, position.getZ() + 0.75 - Minecraft.getInstance().player.level.random.nextDouble() / 2D, 0, 0, 0));
    }

}
