package com.buuz135.findme.network;

import I;
import com.buuz135.findme.FindMeMod;
import com.buuz135.findme.IInventoryPuller;
import com.buuz135.findme.tracking.TrackingList;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class PullItemRequestMessage {

    private class_1799 stack;
    private int amount;

    public PullItemRequestMessage(class_1799 stack, int amount) {
        this.stack = stack;
        this.amount = amount;
        TrackingList.trackItem(stack);
    }

    public PullItemRequestMessage() {

    }

    public static boolean compareItems(class_1799 first, class_1799 second) {
        if (FindMeMod.CONFIG.COMMON.IGNORE_ITEM_DAMAGE)
            return class_1799.method_7984(first, second);
        return class_1799.method_31577(first, second);
    }

    public PullItemRequestMessage fromBytes(ByteBuf buf) {
        class_2540 packetBuffer = new class_2540(buf);
        stack = class_1799.field_8037;
        stack = packetBuffer.method_10819();
        amount = packetBuffer.readInt();
        return this;
    }

    public void toBytes(ByteBuf buf) {
        class_2540 packetBuffer = new class_2540(buf);
        packetBuffer.method_10793(stack);
        packetBuffer.writeInt(amount);
    }

    public void handle(Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            class_238 box = new class_238(contextSupplier.get().getPlayer().method_24515()).method_1014(FindMeMod.CONFIG.COMMON.RADIUS_RANGE);
            var currentAmount = 0;
            for (class_2338 blockPos : PositionRequestMessage.getBlockPosInAABB(box)) {
                class_2586 tileEntity = contextSupplier.get().getPlayer().method_37908().method_8321(blockPos);
                if (tileEntity != null) {
                    for (IInventoryPuller blockExtractor : FindMeMod.BLOCK_EXTRACTORS) {
                        currentAmount += blockExtractor.pull(tileEntity, stack, amount - currentAmount, contextSupplier.get().getPlayer());
                        if (currentAmount >= amount) {
                            break;
                        }
                    }
                }
                if (currentAmount >= amount) {
                    break;
                }
            }
            if (currentAmount < amount) {
                var player = contextSupplier.get().getPlayer();
                var level = player.method_37908();
                level.method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(),
                        class_3417.field_15102, class_3419.field_15248, 0.5F, ((level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.7F + 1.0F) * 2.0F);
            }
        });
        //contextSupplier.get().setPacketHandled(true);
    }
}
