/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticlePosition
extends SingleQuadParticle {
    public static ParticleRenderType CUSTOM = new ParticleRenderType(){

        public void begin(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::getParticleShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("textures/particle/glitter_4.png"));
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public void end(Tesselator tesselator) {
            tesselator.end();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableDepthTest();
        }

        public String toString() {
            return "CUSTOM2";
        }
    };

    public ParticlePosition(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        float color;
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.xd += motionX;
        this.yd += motionY;
        this.zd += motionZ;
        this.rCol = color = 1.0f - (float)(Math.random() * (double)0.3f);
        this.gCol = color;
        this.bCol = color;
        this.lifetime = 100;
        this.hasPhysics = false;
    }

    public ParticleRenderType getRenderType() {
        return CUSTOM;
    }

    public float getQuadSize(float p_217561_1_) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + p_217561_1_) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    protected float getU0() {
        return 0.0f;
    }

    protected float getU1() {
        return 1.0f;
    }

    protected float getV0() {
        return 0.0f;
    }

    protected float getV1() {
        return 1.0f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        super.render(buffer, renderInfo, partialTicks);
    }

    protected int getLightColor(float f) {
        return 0xF000F0;
    }
}

