/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.network;

import com.buuz135.findme.FindMeMod;
import com.buuz135.findme.client.ClientTickHandler;
import com.buuz135.findme.tracking.TrackingList;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PositionResponseMessage
implements Serializable {
    private List<BlockPos> positions;

    public PositionResponseMessage(List<BlockPos> positions) {
        this.positions = positions;
    }

    public PositionResponseMessage() {
    }

    public PositionResponseMessage fromBytes(ByteBuf buf) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(buf);
        this.positions = new ArrayList<BlockPos>();
        for (int amount = packetBuffer.readInt(); amount > 0; --amount) {
            this.positions.add(packetBuffer.readBlockPos());
        }
        return this;
    }

    public void toBytes(ByteBuf buf) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(buf);
        packetBuffer.writeInt(this.positions.size());
        for (BlockPos position : this.positions) {
            packetBuffer.writeBlockPos(position);
        }
    }

    public void handle(Supplier<NetworkManager.PacketContext> context) {
        Minecraft.getInstance().execute(() -> {
            if (this.positions.size() > 0) {
                Minecraft.getInstance().player.closeContainer();
                if (FindMeMod.CONFIG.CLIENT.CONTAINER_TRACKING) {
                    TrackingList.beginTracking();
                    ClientTickHandler.addRunnable(TrackingList::clear, FindMeMod.CONFIG.CLIENT.CONTAINER_TRACK_TIME);
                }
                for (BlockPos position : this.positions) {
                    for (int i = 0; i < 2; ++i) {
                        this.addParticle(position);
                    }
                }
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addParticle(BlockPos position) {
        Minecraft.getInstance().player.level().addParticle((ParticleOptions)FindMeMod.FINDME.get(), (double)position.getX() + 0.75 - Minecraft.getInstance().player.level().random.nextDouble() / 2.0, (double)position.getY() + 0.75 - Minecraft.getInstance().player.level().random.nextDouble() / 2.0, (double)position.getZ() + 0.75 - Minecraft.getInstance().player.level().random.nextDouble() / 2.0, 0.0, 0.0, 0.0);
    }
}

