package com.buuz135.findme;

import com.buuz135.findme.client.ClientTickHandler;
import com.buuz135.findme.client.ParticlePosition;
import com.buuz135.findme.network.PositionRequestMessage;
import com.buuz135.findme.network.PullItemRequestMessage;
import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;

import java.util.ArrayList;

import static net.minecraft.client.particle.ParticleEngine.f_107288_;

public class FindMeModClient {


    public static KeyMapping KEY = new KeyMapping("key.findme.search", InputConstants.m_84851_("key.keyboard.y").m_84873_(), "key.findme.category");
    public static KeyMapping PULL_ONE = new KeyMapping("key.findme.pull_one", InputConstants.m_84851_("key.keyboard.keypad.0").m_84873_(), "key.findme.category");
    public static KeyMapping PULL_STACK = new KeyMapping("key.findme.pull_stack", InputConstants.m_84851_("key.keyboard.keypad.1").m_84873_(), "key.findme.category");



    public static long lastTooltipTime = 0;
    public static ItemStack lastRenderedStack = ItemStack.f_41583_;

    public FindMeModClient() {
        init();
    }

    private static void init() {
        KeyMappingRegistry.register(KEY);
        KeyMappingRegistry.register(PULL_ONE);
        KeyMappingRegistry.register(PULL_STACK);
        ClientTickEvent.CLIENT_PRE.register(instance -> ClientTickHandler.clientTick());
        ClientTooltipEvent.ITEM.register((stack, lines, flag) -> {
            if (!stack.m_41619_() && Minecraft.m_91087_().f_91073_ != null) {
                lastRenderedStack = stack;
                lastTooltipTime = Minecraft.m_91087_().f_91073_.m_46467_();
            }
        });
        ClientRawInputEvent.KEY_PRESSED.register((client, keyCode, scanCode, action, modifiers) -> {
            if (!lastRenderedStack.m_41619_() && client.f_91073_ != null && client.f_91073_.m_46467_() - lastTooltipTime < 3) {
                if (KEY.m_90832_(keyCode, scanCode))
                    FindMeMod.CHANNEL.sendToServer(new PositionRequestMessage(lastRenderedStack));
                if (PULL_ONE.m_90832_(keyCode, scanCode) && action == 1)
                    FindMeMod.CHANNEL.sendToServer(new PullItemRequestMessage(lastRenderedStack, 1));
                if (PULL_STACK.m_90832_(keyCode, scanCode) && action == 1)
                    FindMeMod.CHANNEL.sendToServer(new PullItemRequestMessage(lastRenderedStack, lastRenderedStack.m_41741_()));
            }
            return EventResult.pass();
        });
        if (!f_107288_.contains(ParticlePosition.CUSTOM)) {
            f_107288_ = new ArrayList<>(f_107288_);
            f_107288_.add(ParticlePosition.CUSTOM);
        }
    }

}
