package com.buuz135.findme.client;

import com.buuz135.findme.FindMeMod;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

import java.awt.*;

@Environment(EnvType.CLIENT)
public class ParticlePosition extends SingleQuadParticle {

    public static ParticleRenderType CUSTOM = new ParticleRenderType() {
        public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask(true);
            RenderSystem.setShader(GameRenderer::m_172829_);
            RenderSystem.setShaderTexture(0, new ResourceLocation("textures/particle/glitter_4.png"));
            RenderSystem.enableBlend();
            RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            //RenderSystem.alphaFunc(516, 0.003921569F);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
            RenderSystem.disableBlend();
            RenderSystem.depthMask(false);
            RenderSystem.enableDepthTest();
        }

        public String toString() {
            return "CUSTOM2";
        }
    };

    public ParticlePosition(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z, 0.0D, 0.0D, 0.0D);
        this.f_107215_ *= 0.10000000149011612D;
        this.f_107216_ *= 0.10000000149011612D;
        this.f_107217_ *= 0.10000000149011612D;
        this.f_107215_ += motionX;
        this.f_107216_ += motionY;
        this.f_107217_ += motionZ;
        float colorOffset = (float) (Math.random() * 0.30000001192092896D);
        Color c = FindMeMod.CONFIG.CLIENT.getParticleColor();
        this.f_107227_ = ((float)c.getRed()) / 255f - colorOffset;
        this.f_107228_ = ((float)c.getGreen()) / 255f - colorOffset;
        this.f_107229_ = ((float)c.getBlue()) / 255f - colorOffset;
        //this.particleScale *= 1.5F;
        this.f_107225_ = 20 * 5;
        this.f_107219_ = false;
    }

    @Override
    public ParticleRenderType m_7556_() {
        return CUSTOM;
    }

    @Override
    public float m_5902_(float p_217561_1_) {
        return this.f_107663_ * Mth.m_14036_(((float) this.f_107224_ + p_217561_1_) / (float) this.f_107225_ * 32.0F, 0.0F, 1.0F);
    }

    @Override
    protected float m_5970_() {
        return 0;
    }

    @Override
    protected float m_5952_() {
        return 1f;
    }

    @Override
    protected float m_5951_() {
        return 0;
    }

    @Override
    protected float m_5950_() {
        return 1f;
    }

    @Override
    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @Override
    public void m_107271_(float alpha) {
        super.m_107271_(alpha);
    }

    @Override
    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        super.m_5744_(buffer, renderInfo, partialTicks);
    }

    @Override
    protected int m_6355_(float f) {
        return 15728880;
    }
}
