package com.buuz135.findme.network;


import com.buuz135.findme.FindMeMod;
import com.buuz135.findme.client.ClientTickHandler;
import com.buuz135.findme.tracking.TrackingList;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class PositionResponseMessage implements Serializable {

    private List<BlockPos> positions;

    public PositionResponseMessage(List<BlockPos> positions) {
        this.positions = positions;
    }

    public PositionResponseMessage() {
    }

    public PositionResponseMessage fromBytes(ByteBuf buf) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(buf);
        int amount = packetBuffer.readInt();
        positions = new ArrayList<>();
        while (amount > 0) {
            positions.add(packetBuffer.m_130135_());
            --amount;
        }
        return this;
    }

    public void toBytes(ByteBuf buf) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(buf);
        packetBuffer.writeInt(positions.size());
        for (BlockPos position : positions) {
            packetBuffer.m_130064_(position);
        }
    }

    public void handle(Supplier<NetworkManager.PacketContext> context) {
        Minecraft.m_91087_().execute(() -> {
            if (positions.size() > 0) {
                Minecraft.m_91087_().f_91074_.m_6915_();
                if (FindMeMod.CONFIG.CLIENT.CONTAINER_TRACKING) {
                    TrackingList.beginTracking();
                    ClientTickHandler.addRunnable(TrackingList::clear, FindMeMod.CONFIG.CLIENT.CONTAINER_TRACK_TIME);
                }
                for (BlockPos position : positions) {
                    for (int i = 0; i < 2; ++i)
                        addParticle(position);
                }
            }
        });
        //context.get().setPacketHandled(true);
    }

    @Environment(EnvType.CLIENT)
    public void addParticle(BlockPos position) {
        Minecraft.m_91087_().f_91074_.m_9236_().m_7106_((ParticleOptions) FindMeMod.FINDME.get(), position.m_123341_() + 0.75 - Minecraft.m_91087_().f_91074_.m_9236_().f_46441_.m_188500_() / 2D, position.m_123342_() + 0.75 - Minecraft.m_91087_().f_91074_.m_9236_().f_46441_.m_188500_() / 2D, position.m_123343_() + 0.75 - Minecraft.m_91087_().f_91074_.m_9236_().f_46441_.m_188500_() / 2D, 0, 0, 0);
        //Minecraft.getInstance().particleEngine.add(new AshParticle((ClientLevel) Minecraft.getInstance().player.level, position.getX() + 0.75 - Minecraft.getInstance().player.level.random.nextDouble() / 2D, position.getY() + 0.75 - Minecraft.getInstance().player.level.random.nextDouble() / 2D, position.getZ() + 0.75 - Minecraft.getInstance().player.level.random.nextDouble() / 2D, 0, 0, 0));
    }

}
