package com.buuz135.findme.network;

import I;
import com.buuz135.findme.FindMeMod;
import com.buuz135.findme.IInventoryPuller;
import com.buuz135.findme.tracking.TrackingList;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

import java.util.function.Supplier;

public class PullItemRequestMessage {

    private ItemStack stack;
    private int amount;

    public PullItemRequestMessage(ItemStack stack, int amount) {
        this.stack = stack;
        this.amount = amount;
        TrackingList.trackItem(stack);
    }

    public PullItemRequestMessage() {

    }

    public static boolean compareItems(ItemStack first, ItemStack second) {
        if (FindMeMod.CONFIG.COMMON.IGNORE_ITEM_DAMAGE)
            return ItemStack.m_41656_(first, second);
        return ItemStack.m_150942_(first, second);
    }

    public PullItemRequestMessage fromBytes(ByteBuf buf) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(buf);
        stack = ItemStack.f_41583_;
        stack = packetBuffer.m_130267_();
        amount = packetBuffer.readInt();
        return this;
    }

    public void toBytes(ByteBuf buf) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(buf);
        packetBuffer.m_130055_(stack);
        packetBuffer.writeInt(amount);
    }

    public void handle(Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            AABB box = new AABB(contextSupplier.get().getPlayer().m_20183_()).m_82400_(FindMeMod.CONFIG.COMMON.RADIUS_RANGE);
            var currentAmount = 0;
            for (BlockPos blockPos : PositionRequestMessage.getBlockPosInAABB(box)) {
                BlockEntity tileEntity = contextSupplier.get().getPlayer().m_9236_().m_7702_(blockPos);
                if (tileEntity != null) {
                    for (IInventoryPuller blockExtractor : FindMeMod.BLOCK_EXTRACTORS) {
                        currentAmount += blockExtractor.pull(tileEntity, stack, amount - currentAmount, contextSupplier.get().getPlayer());
                        if (currentAmount >= amount) {
                            break;
                        }
                    }
                }
                if (currentAmount >= amount) {
                    break;
                }
            }
            if (currentAmount < amount) {
                var player = contextSupplier.get().getPlayer();
                var level = player.m_9236_();
                level.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(),
                        SoundEvents.f_11937_, SoundSource.PLAYERS, 0.5F, ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.7F + 1.0F) * 2.0F);
            }
        });
        //contextSupplier.get().setPacketHandled(true);
    }
}
