/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.mcmmo.command;

import cn.handyplus.mcmmo.constants.TabListEnum;
import cn.handyplus.mcmmo.lib.annotation.HandyCommand;
import cn.handyplus.mcmmo.lib.command.HandyCommandWrapper;
import cn.handyplus.mcmmo.lib.util.BaseUtil;
import cn.handyplus.mcmmo.lib.util.MessageUtil;
import cn.handyplus.mcmmo.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

@HandyCommand(name="mcMmoView")
public class McMmoViewCommand
implements TabExecutor {
    private static final String PERMISSION = "mcMmoView.reload";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length < 1) {
            this.sendHelp(sender);
            return true;
        }
        boolean rst = HandyCommandWrapper.onCommand(sender, cmd, label, args, BaseUtil.getMsgNotColor("noPermission"));
        if (!rst) {
            this.sendHelp(sender);
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<String> commands = TabListEnum.returnList(args, args.length);
        if (commands == null) {
            return null;
        }
        StringUtil.copyPartialMatches((String)args[args.length - 1].toLowerCase(), commands, completions);
        Collections.sort(completions);
        return completions;
    }

    private void sendHelp(CommandSender sender) {
        if (!sender.hasPermission(PERMISSION)) {
            return;
        }
        List helps = ConfigUtil.LANG_CONFIG.getStringList("helps");
        for (String help : helps) {
            MessageUtil.sendMessage(sender, help);
        }
    }
}

