/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.mcmmo.inventory;

import cn.handyplus.mcmmo.constants.GuiTypeEnum;
import cn.handyplus.mcmmo.hook.PlaceholderApiUtil;
import cn.handyplus.mcmmo.lib.constants.BaseConstants;
import cn.handyplus.mcmmo.lib.constants.VersionCheckEnum;
import cn.handyplus.mcmmo.lib.core.StrUtil;
import cn.handyplus.mcmmo.lib.inventory.HandyInventory;
import cn.handyplus.mcmmo.lib.inventory.HandyInventoryUtil;
import cn.handyplus.mcmmo.lib.util.ItemStackUtil;
import cn.handyplus.mcmmo.util.ConfigUtil;
import com.gmail.nossr50.api.ExperienceAPI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OpenGui {
    private static final OpenGui INSTANCE = new OpenGui();

    private OpenGui() {
    }

    public static OpenGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.LANG_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int openSize = ConfigUtil.CONFIG.getInt("openSize", 54);
        String sound = ConfigUtil.LANG_CONFIG.getString("sound");
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.MC_MMO_VIEW.getType(), title, openSize, sound);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.MC_MMO_VIEW.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, String> strMap = handyInventory.getStrMap();
        Player player = handyInventory.getPlayer();
        Map<Integer, String> soundMap = handyInventory.getSoundMap();
        ConfigurationSection configurationSection = ConfigUtil.LANG_CONFIG.getConfigurationSection("skill");
        if (configurationSection == null) {
            return;
        }
        Map values = configurationSection.getValues(false);
        for (String key : values.keySet()) {
            MemorySection memorySection = (MemorySection)values.get(key);
            if (memorySection == null) continue;
            String indexStrList = memorySection.getString("index");
            List<Integer> indexList = StrUtil.strToIntList(indexStrList);
            String material = memorySection.getString("material");
            if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_21.getVersionId() && "MACE".equalsIgnoreCase(material)) continue;
            String name = memorySection.getString("name");
            String sound = memorySection.getString("sound");
            List<String> loreList = memorySection.getStringList("lore");
            int customModelDataId = memorySection.getInt("custom-model-data");
            boolean enchant = memorySection.getBoolean("isEnchant", false);
            boolean hideFlag = memorySection.getBoolean("hideFlag", true);
            boolean hideEnchant = memorySection.getBoolean("hideEnchant", true);
            String headBase = memorySection.getString("headBase");
            String head = memorySection.getString("head");
            String tooltipStyle = memorySection.getString("tooltipStyle");
            String itemModel = memorySection.getString("itemModel");
            if (StrUtil.isNotEmpty(head) && player != null) {
                head = StrUtil.replace(head, "player", player.getName());
            }
            for (Integer index : indexList) {
                name = PlaceholderApiUtil.set(player, name);
                loreList = PlaceholderApiUtil.set(player, loreList);
                ItemStack itemStack = ItemStackUtil.getItemStack(material, name, loreList, enchant, customModelDataId, hideFlag, this.replaceMap(handyInventory.getPlayer(), key), hideEnchant, null, tooltipStyle, itemModel);
                ItemStackUtil.setSkull(itemStack, headBase);
                ItemStackUtil.setOwner(itemStack, head);
                inventory.setItem(index.intValue(), itemStack);
                if ("pane".equalsIgnoreCase(key) || "me".equalsIgnoreCase(key)) continue;
                if ("back".equalsIgnoreCase(key)) {
                    strMap.put(index, memorySection.getString("command"));
                    continue;
                }
                strMap.put(index, key);
                soundMap.put(index, sound);
            }
        }
    }

    private Map<String, String> replaceMap(Player player, String key) {
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        if ("pane".equalsIgnoreCase(key) || "back".equalsIgnoreCase(key)) {
            return replaceMap;
        }
        if ("me".equalsIgnoreCase(key)) {
            replaceMap.put("all", ExperienceAPI.getPowerLevel((Player)player) + "");
            return replaceMap;
        }
        if ("SALVAGE".equalsIgnoreCase(key) || "SMELTING".equalsIgnoreCase(key)) {
            replaceMap.put("xp", ExperienceAPI.getLevel((Player)player, (String)key) + "");
        } else {
            replaceMap.put("xp", ExperienceAPI.getLevel((Player)player, (String)key) + "");
            replaceMap.put("need", ExperienceAPI.getXPRemaining((Player)player, (String)key) + "");
            replaceMap.put("on", ExperienceAPI.getXPRaw((Player)player, (String)key) + "");
            replaceMap.put("next", ExperienceAPI.getXPToNextLevel((Player)player, (String)key) + "");
        }
        return replaceMap;
    }
}

