/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.mcmmo.lib.core;

import cn.handyplus.mcmmo.lib.constants.BaseConstants;
import cn.handyplus.mcmmo.lib.constants.VersionCheckEnum;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static String toJson(@NotNull Object obj) {
        return new Gson().toJson(obj);
    }

    public static <T> T toBean(@NotNull String json, @NotNull Class<T> t) {
        return (T)new Gson().fromJson(json, t);
    }

    public static <T> List<T> toList(@NotNull String json, @NotNull Class<T> t) {
        if (BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_12.getVersionId()) {
            return (List)new Gson().fromJson(json, TypeToken.getParameterized(List.class, (Type[])new Type[]{t}).getType());
        }
        JsonArray arr = new JsonParser().parse(json).getAsJsonArray();
        ArrayList<T> list = new ArrayList<T>(arr.size());
        for (JsonElement el : arr) {
            list.add(JsonUtil.toBean(el.toString(), t));
        }
        return list;
    }

    public static Map<String, String> toMap(@NotNull String json) {
        return (Map)new Gson().fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
    }

    public static Map<Integer, String> toIntMap(@NotNull String json) {
        return (Map)new Gson().fromJson(json, new TypeToken<Map<Integer, String>>(){}.getType());
    }

    public static Map<String, Object> toObjMap(@NotNull String json) {
        return (Map)new Gson().fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
    }

    public static Map<String, String> objectToMap(@NotNull Object obj) {
        return JsonUtil.toMap(JsonUtil.toJson(obj));
    }

    public static <T> boolean writeListToJson(@NotNull List<T> list, File file) {
        boolean bl;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson(list, (Appendable)writer);
            bl = true;
        }
        return bl;
    }
}

