/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.mcmmo.lib.util;

import cn.handyplus.mcmmo.lib.constants.BaseConstants;
import cn.handyplus.mcmmo.lib.constants.HookPluginEnum;
import cn.handyplus.mcmmo.lib.constants.VersionCheckEnum;
import cn.handyplus.mcmmo.lib.core.CollUtil;
import cn.handyplus.mcmmo.lib.core.JsonUtil;
import cn.handyplus.mcmmo.lib.core.NetUtil;
import cn.handyplus.mcmmo.lib.core.PatternUtil;
import cn.handyplus.mcmmo.lib.core.StrUtil;
import cn.handyplus.mcmmo.lib.util.AssertUtil;
import cn.handyplus.mcmmo.lib.util.HandyHttpUtil;
import cn.handyplus.mcmmo.lib.util.ItemStackUtil;
import cn.handyplus.mcmmo.lib.util.LegacyUtil;
import cn.handyplus.mcmmo.lib.util.MessageUtil;
import cn.handyplus.mcmmo.lib.util.RgbTextUtil;
import cn.handyplus.mcmmo.lib.util.TranslationUtil;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class BaseUtil {
    private BaseUtil() {
    }

    public static Boolean isPlayer(@NotNull CommandSender sender) {
        return sender instanceof Player;
    }

    public static Player getOnlinePlayer(@NotNull CommandSender sender, @NotNull String playerName, @NotNull String msg) {
        if (StrUtil.isEmpty(playerName)) {
            return AssertUtil.notPlayer(sender, msg);
        }
        return BaseUtil.getOnlinePlayer(playerName).orElseThrow(() -> new RuntimeException(msg));
    }

    public static Optional<Player> getOnlinePlayer(@NotNull String playerName) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player == null || !player.isOnline()) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public static Optional<Player> getOnlinePlayer(@NotNull UUID playerUuid) {
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null || !player.isOnline()) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public static OfflinePlayer getOfflinePlayer(@NotNull String playerName) {
        return Bukkit.getOfflinePlayer((String)playerName);
    }

    public static OfflinePlayer getOfflinePlayer(@NotNull UUID playerUuid) {
        return Bukkit.getOfflinePlayer((UUID)playerUuid);
    }

    public static Boolean isNotPlayer(@NotNull CommandSender sender) {
        return BaseUtil.isPlayer(sender) == false;
    }

    public static String replaceChatColor(@NotNull String str) {
        if (StrUtil.isEmpty(str)) {
            return "";
        }
        String replaceStr = str.replace("&", "\u00a7");
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_16.getVersionId()) {
            return replaceStr;
        }
        return BaseUtil.translateColorCodes(replaceStr);
    }

    public static List<String> replaceChatColor(@NotNull List<String> strList) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (CollUtil.isEmpty(strList)) {
            return loreList;
        }
        for (String lore : strList) {
            loreList.add(BaseUtil.replaceChatColor(lore));
        }
        return loreList;
    }

    public static String stripColor(@NotNull String str) {
        if (StrUtil.isEmpty(str)) {
            return "";
        }
        return ChatColor.stripColor((String)BaseUtil.replaceChatColor(str));
    }

    public static UUID getUuid(@NotNull String playerName) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        return offlinePlayer.getUniqueId();
    }

    public static String getLangMsg(@NotNull String langMsg) {
        return BaseUtil.getLangMsg(langMsg, "");
    }

    public static String getLangMsg(@NotNull String langMsg, @NotNull String defaultMsg) {
        return BaseUtil.getLangMsg(langMsg, defaultMsg, true);
    }

    public static String getMsgNotColor(@NotNull String langMsg) {
        return BaseUtil.getMsgNotColor(langMsg, "");
    }

    public static String getMsgNotColor(@NotNull String langMsg, @NotNull Map<String, String> replaceMap) {
        String msgNotColor = BaseUtil.getMsgNotColor(langMsg, "");
        if (replaceMap != null) {
            for (String key : replaceMap.keySet()) {
                msgNotColor = msgNotColor.replace(key, replaceMap.get(key));
            }
        }
        return msgNotColor;
    }

    public static String getMsgNotColor(@NotNull String langMsg, @NotNull String defaultMsg) {
        return BaseUtil.getLangMsg(langMsg, defaultMsg, false);
    }

    public static String getLangMsg(@NotNull String langMsg, @NotNull String defaultMsg, boolean isColor) {
        if (StrUtil.isEmpty(langMsg)) {
            return defaultMsg;
        }
        FileConfiguration langConfig = BaseConstants.LANG_CONFIG;
        if (langConfig == null) {
            return defaultMsg;
        }
        String msg = langConfig.getString(langMsg, defaultMsg);
        return isColor ? BaseUtil.replaceChatColor(msg) : msg;
    }

    @NotNull
    public static String getDisplayName(ItemStack itemStack) {
        String name;
        if (itemStack == null) {
            itemStack = new ItemStack(Material.AIR);
        }
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        String type = itemStack.getType().name();
        if (BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_20_5.getVersionId() && itemMeta.hasItemName()) {
            return itemMeta.getItemName();
        }
        if (itemMeta.hasDisplayName()) {
            return itemMeta.getDisplayName();
        }
        String materialTranslation = TranslationUtil.getMaterialTranslation(type);
        if (StrUtil.isNotEmpty(materialTranslation)) {
            return materialTranslation;
        }
        if (!BaseConstants.ITEM_JSON_CACHE_MAP.isEmpty() && (name = BaseConstants.ITEM_JSON_CACHE_MAP.get(type)) != null) {
            return name;
        }
        if (!BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.isEmpty()) {
            String legacyName;
            if (itemStack.getDurability() > 0 && StrUtil.isNotEmpty(legacyName = BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.get(type + "_" + itemStack.getDurability()))) {
                return legacyName;
            }
            name = BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.get(type);
            if (name != null) {
                return name;
            }
        }
        return type;
    }

    public static void readJsonFileToItemJsonCacheMap(@NotNull File file) {
        Optional<String> jsonOpt = BaseUtil.readJsonFile(file);
        if (jsonOpt.isPresent() && jsonOpt.get().length() > 1) {
            try {
                BaseConstants.ITEM_JSON_CACHE_MAP = JsonUtil.toMap(jsonOpt.get());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void readJsonFileToJsonCacheMap(@NotNull File file) {
        try {
            Optional<String> jsonOpt = BaseUtil.readJsonFile(file);
            jsonOpt.ifPresent(s -> {
                BaseConstants.JSON_CACHE_MAP = JsonUtil.toMap(s);
            });
        }
        catch (Throwable ignored) {
            MessageUtil.sendConsoleDebugMessage("\u8bfb\u53d6item.json\u5f02\u5e38");
        }
    }

    public static Optional<String> readJsonFile(@NotNull File fileName) {
        try {
            int ch;
            FileReader fileReader = new FileReader(fileName);
            InputStreamReader reader = new InputStreamReader(Files.newInputStream(fileName.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            StringBuilder sb = new StringBuilder();
            while ((ch = ((Reader)reader).read()) != -1) {
                sb.append((char)ch);
            }
            fileReader.close();
            ((Reader)reader).close();
            return Optional.of(sb.toString());
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "readJsonFile \u53d1\u751f\u5f02\u5e38", e);
            return Optional.empty();
        }
    }

    public static int getFirstPluginVersion(@NotNull Plugin plugin) {
        String version = plugin.getDescription().getVersion();
        String[] split = version.split("\\.");
        return Integer.parseInt(split[0]);
    }

    public static int getTwoPluginVersion(@NotNull Plugin plugin) {
        String version = plugin.getDescription().getVersion();
        String[] split = version.split("\\.");
        return Integer.parseInt(split[1]);
    }

    public static Integer convertVersion(@NotNull String version) {
        String[] versionParts;
        String cleanedVersion = version.replaceAll("[^\\d.]", "");
        if (!cleanedVersion.contains(".")) {
            return Integer.parseInt(cleanedVersion);
        }
        StringBuilder result = new StringBuilder();
        for (String part : versionParts = cleanedVersion.split("\\.")) {
            if (part.length() == 1) {
                result.append("0");
            }
            result.append(part);
        }
        return Integer.parseInt(result.toString());
    }

    public static Optional<Sound> getSound(@NotNull String sound) {
        try {
            return Optional.of(LegacyUtil.getSound(sound));
        }
        catch (Exception exception) {
            if (BaseConstants.DEBUG) {
                Bukkit.getLogger().log(Level.SEVERE, "getSound \u53d1\u751f\u5f02\u5e38", exception);
            }
            return Optional.empty();
        }
    }

    public static Optional<Biome> getBiome(@NotNull String biome) {
        try {
            return Optional.of(LegacyUtil.getBiome(biome));
        }
        catch (Exception exception) {
            if (BaseConstants.DEBUG) {
                Bukkit.getLogger().log(Level.SEVERE, "getBiome \u53d1\u751f\u5f02\u5e38", exception);
            }
            return Optional.empty();
        }
    }

    public static Optional<EntityType> getEntityType(@NotNull String key) {
        try {
            return Optional.of(EntityType.valueOf((String)key.toUpperCase()));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    public static Optional<Plugin> hook(@NotNull String pluginName) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
        return plugin != null && plugin.isEnabled() ? Optional.of(plugin) : Optional.empty();
    }

    public static boolean hook(@NotNull String pluginName, @NotNull String succeedMsgNode, @NotNull String failureMsgNode) {
        Optional<Plugin> pluginOpt = BaseUtil.hook(pluginName);
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(pluginOpt.isPresent() ? succeedMsgNode : failureMsgNode));
        return pluginOpt.isPresent();
    }

    public static boolean hook(@NotNull String pluginName, @NotNull String succeedMsgNode, @NotNull String failureMsgNode, @NotNull Integer version) {
        int firstPluginVersion;
        Optional<Object> pluginOpt = BaseUtil.hook(pluginName);
        if (pluginOpt.isPresent() && (firstPluginVersion = BaseUtil.getFirstPluginVersion(pluginOpt.get())) < version) {
            pluginOpt = Optional.empty();
        }
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(pluginOpt.isPresent() ? succeedMsgNode : failureMsgNode));
        return pluginOpt.isPresent();
    }

    public static boolean hook(@NotNull HookPluginEnum hookPluginEnum) {
        return BaseUtil.hook(hookPluginEnum.getName(), hookPluginEnum.getSuccessMsg(), hookPluginEnum.getFailMsg());
    }

    public static boolean hook(@NotNull HookPluginEnum hookPluginEnum, @NotNull Integer version) {
        return BaseUtil.hook(hookPluginEnum.getName(), hookPluginEnum.getSuccessMsg(), hookPluginEnum.getFailMsg(), version);
    }

    public static Optional<Plugin> hookToPlugin(@NotNull HookPluginEnum hookPluginEnum) {
        Optional<Plugin> pluginOpt = BaseUtil.hook(hookPluginEnum.getName());
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(pluginOpt.isPresent() ? hookPluginEnum.getSuccessMsg() : hookPluginEnum.getFailMsg()));
        return pluginOpt;
    }

    public static void sendTip(@NotNull CommandSender sender) {
        String mac;
        String signType = BaseConstants.CONFIG.getString("signType", "mac");
        String string = mac = "mac".equalsIgnoreCase(signType) ? NetUtil.getLocalMacAddress() : HandyHttpUtil.getIp();
        if (BaseUtil.isPlayer(sender).booleanValue() && BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_15.getVersionId()) {
            RgbTextUtil rgbTextUtil = RgbTextUtil.getInstance().init(mac);
            String copy = BaseUtil.getMsgNotColor("copy", "&r   &8[&a\u70b9\u51fb\u590d\u5236&8]");
            rgbTextUtil.addExtra(RgbTextUtil.getInstance().init(copy).addClickCopyToClipboard(mac).build());
            rgbTextUtil.send((Player)sender);
            return;
        }
        MessageUtil.sendMessage(sender, mac);
    }

    public static void isPrimaryThread(@NotNull String name) {
        if (!BaseConstants.DEBUG) {
            return;
        }
        MessageUtil.sendConsoleMessage(name + ": " + Bukkit.isPrimaryThread());
    }

    private static String translateColorCodes(@NotNull String str) {
        Matcher matcher = PatternUtil.RPG_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group();
            if (hex.length() == 5) {
                hex = hex.substring(0, 2) + BaseUtil.doubleCharacters(hex.substring(2));
            }
            matcher.appendReplacement(sb, ChatColor.of((String)hex.substring(1)).toString());
        }
        matcher.appendTail(sb);
        return ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)sb.toString());
    }

    private static String doubleCharacters(@NotNull String str) {
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            sb.append(c);
            sb.append(c);
        }
        return sb.toString();
    }
}

