/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.mcmmo.lib.util;

import cn.handyplus.mcmmo.lib.InitApi;
import cn.handyplus.mcmmo.lib.core.JsonUtil;
import cn.handyplus.mcmmo.lib.core.MapUtil;
import cn.handyplus.mcmmo.lib.core.StrUtil;
import cn.handyplus.mcmmo.lib.util.MessageUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class BcUtil {
    public static final String BUNGEE_CORD_CHANNEL = "BungeeCord";
    private static final String CONNECT = "Connect";
    private static final String FORWARD = "Forward";
    private static final String GET_SERVER = "GetServer";
    private static final String PLAYER_COUNT = "PlayerCount";
    private static final String PLAYER_LIST = "PlayerList";
    private static final String ALL = "ALL";

    private BcUtil() {
    }

    public static void registerOut() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)InitApi.PLUGIN, BUNGEE_CORD_CHANNEL);
    }

    public static void unregisterOut() {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)InitApi.PLUGIN, BUNGEE_CORD_CHANNEL);
    }

    public static void tpConnect(Player player, String serverName) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(CONNECT);
        out.writeUTF(serverName);
        player.sendPluginMessage((Plugin)InitApi.PLUGIN, BUNGEE_CORD_CHANNEL, out.toByteArray());
    }

    public static void sendForward(Player player, String content) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(FORWARD);
        out.writeUTF(ALL);
        out.writeUTF(BUNGEE_CORD_CHANNEL);
        ByteArrayDataOutput dataOut = ByteStreams.newDataOutput();
        dataOut.writeUTF(content);
        out.writeShort(dataOut.toByteArray().length);
        out.write(dataOut.toByteArray());
        player.sendPluginMessage((Plugin)InitApi.PLUGIN, BUNGEE_CORD_CHANNEL, out.toByteArray());
    }

    public static Optional<String> getContentByForward(byte[] message) {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String subChannel = in.readUTF();
        if (!BUNGEE_CORD_CHANNEL.equals(subChannel)) {
            return Optional.empty();
        }
        byte[] bytes = new byte[in.readShort()];
        in.readFully(bytes);
        ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])bytes);
        return Optional.of(dataInput.readUTF());
    }

    public static void sendParamForward(Player player, BcMessageParam content) {
        BcUtil.sendForward(player, JsonUtil.toJson(content));
    }

    public static Optional<BcMessageParam> getParamByForward(byte[] message) {
        Optional<String> jsonOpt = BcUtil.getContentByForward(message);
        if (!jsonOpt.isPresent()) {
            return Optional.empty();
        }
        MessageUtil.sendConsoleDebugMessage("\u6d88\u606f\u5185\u5bb9\u4e3a:" + jsonOpt.get());
        BcMessageParam param = JsonUtil.toBean(jsonOpt.get(), BcMessageParam.class);
        if (param == null || StrUtil.isEmpty(param.getPluginName()) || !InitApi.PLUGIN.getName().equals(param.getPluginName())) {
            return Optional.empty();
        }
        return Optional.of(param);
    }

    public static void sendGetServer() {
        Player player = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        if (player == null) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(GET_SERVER);
        player.sendPluginMessage((Plugin)InitApi.PLUGIN, BUNGEE_CORD_CHANNEL, out.toByteArray());
    }

    public static Optional<String> getServerName(byte[] message) {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String type = in.readUTF();
        if (!GET_SERVER.equals(type)) {
            return Optional.empty();
        }
        return Optional.of(in.readUTF());
    }

    public static void sendPlayerCount() {
        Player player = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        if (player == null) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(PLAYER_COUNT);
        out.writeUTF(ALL);
        player.sendPluginMessage((Plugin)InitApi.PLUGIN, BUNGEE_CORD_CHANNEL, out.toByteArray());
    }

    public static Map<String, Integer> getPlayerCount(byte[] message) {
        try {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
            String type = in.readUTF();
            if (!PLAYER_COUNT.equals(type)) {
                return MapUtil.of();
            }
            String server = in.readUTF();
            int count = in.readInt();
            return ImmutableMap.of((Object)server, (Object)count);
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "getPlayerCount \u53d1\u751f\u5f02\u5e38", e);
            return MapUtil.of();
        }
    }

    public static void sendPlayerList() {
        Player player = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        if (player == null) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(PLAYER_LIST);
        out.writeUTF(ALL);
        player.sendPluginMessage((Plugin)InitApi.PLUGIN, BUNGEE_CORD_CHANNEL, out.toByteArray());
    }

    public static List<String> getPlayerList(byte[] message) {
        try {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
            String type = in.readUTF();
            if (!PLAYER_LIST.equals(type)) {
                return new ArrayList<String>();
            }
            String server = in.readUTF();
            String playerList = in.readUTF();
            return StrUtil.strToStrList(playerList, ",");
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "getPlayerList \u53d1\u751f\u5f02\u5e38", e);
            return new ArrayList<String>();
        }
    }

    public static class BcMessageParam {
        private String pluginName;
        private String type;
        private String message;
        private String playerName;
        private Long timestamp;

        @Generated
        public String getPluginName() {
            return this.pluginName;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getPlayerName() {
            return this.playerName;
        }

        @Generated
        public Long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setPlayerName(String playerName) {
            this.playerName = playerName;
        }

        @Generated
        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

