/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.handlers;

import com.icarusfell.diabloloot.handlers.MethodHandler;
import com.icarusfell.diabloloot.resource.CompatibleItemRegistry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class CustomArmorHandler {
    private Item getRandomItem(int level) {
        String[] resourceStrings;
        HashSet<Item> newcollection = new HashSet<Item>();
        for (String resource : resourceStrings = CompatibleItemRegistry.COMPATIBLE_ITEM_ENTRY.getItemList()) {
            int min = MethodHandler.getMinLevelFromString(resource);
            int max = MethodHandler.getMaxLevelFromString(resource);
            if (min >= level || max < level) continue;
            newcollection.add(MethodHandler.getItemFromString(resource));
        }
        Iterator it = newcollection.iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            if (item instanceof ArmorItem) continue;
            it.remove();
        }
        Random rnd = new Random();
        int i = rnd.nextInt(newcollection.size());
        return (Item)newcollection.toArray()[i];
    }

    public ItemStack returnRandomArmor(int level) {
        ItemStack i = new ItemStack((IItemProvider)this.getRandomItem(level));
        return i;
    }

    public void setUnique(ItemStack stack) {
        stack.func_196082_o().func_74757_a("isUnique", true);
        this.setTier(stack, 6);
    }

    public void hideVanillaModifiers(ItemStack stack) {
        stack.func_196082_o().func_74768_a("HideFlags", 63);
        stack.func_196082_o().func_74757_a("Unbreakable", true);
    }

    public void setRandomUUID(ItemStack stack) {
        String rUUID = UUID.randomUUID().toString();
        stack.func_196082_o().func_74778_a("IUUID", rUUID);
    }

    public void setItemLevel(ItemStack stack, int level) {
        stack.func_196082_o().func_74768_a("level", level);
    }

    public int getLevel(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("level");
    }

    public void setRandomTier(ItemStack stack, int commonchance, int uncommonchance, int magicchance, int extraordchance, int legendarychance) {
        if (new Random().nextInt(100) + 1 < commonchance) {
            stack.func_196082_o().func_74768_a("itemTier", 1);
        } else if (new Random().nextInt(100) + 1 < uncommonchance) {
            stack.func_196082_o().func_74768_a("itemTier", 2);
        } else if (new Random().nextInt(100) + 1 < magicchance) {
            stack.func_196082_o().func_74768_a("itemTier", 3);
        } else if (new Random().nextInt(100) + 1 < extraordchance) {
            stack.func_196082_o().func_74768_a("itemTier", 4);
        } else if (new Random().nextInt(100) + 1 < legendarychance) {
            stack.func_196082_o().func_74768_a("itemTier", 5);
        } else {
            stack.func_196082_o().func_74768_a("itemTier", 1);
        }
    }

    public void setStackName(ItemStack stack, String newname) {
        StringTextComponent textcomponent = new StringTextComponent(newname);
        stack.func_200302_a((ITextComponent)textcomponent);
    }

    public void setTier(ItemStack stack, int tier) {
        stack.func_196082_o().func_74768_a("itemTier", tier);
    }

    public int getTier(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("itemTier");
    }

    public void setToBeModified(ItemStack stack) {
        stack.func_196082_o().func_74757_a("canBeModifiedArmor", true);
    }

    public void addStrength(ItemStack stack, double value) {
        stack.func_196082_o().func_74780_a("strength", value);
        stack.func_196082_o().func_74757_a("secondModifier", true);
    }

    public void addDexterity(ItemStack stack, double value) {
        stack.func_196082_o().func_74780_a("dexterity", value);
        stack.func_196082_o().func_74757_a("secondModifier", true);
    }

    public void addIntelligence(ItemStack stack, double value) {
        stack.func_196082_o().func_74780_a("intelligence", value);
        stack.func_196082_o().func_74757_a("secondModifier", true);
    }

    public void addMana(ItemStack stack, double value) {
        stack.func_196082_o().func_74780_a("mana", value);
        stack.func_196082_o().func_74757_a("secondModifier", true);
    }

    public void addEvasion(ItemStack stack, double value, int type) {
        if (type == 0) {
            stack.func_196082_o().func_74780_a("evasionInc+", value);
            stack.func_196082_o().func_74757_a("secondModifier", true);
        }
        if (type == 1) {
            stack.func_196082_o().func_74780_a("evasionInc&", value);
            stack.func_196082_o().func_74757_a("secondModifier", true);
        }
    }

    public void setPhysicalArmor(ItemStack stack, double armor) {
        stack.func_196082_o().func_74780_a("physicalArmor", armor);
    }

    public void setEvasion(ItemStack stack, double armor) {
        stack.func_196082_o().func_74780_a("evasion", armor);
    }

    public void setHP(ItemStack stack, double health) {
        stack.func_196082_o().func_74780_a("hp", health);
    }

    public void setFireArmor(ItemStack stack, double Armor) {
        stack.func_196082_o().func_74780_a("fireArmor", Armor);
    }

    public void setIceArmor(ItemStack stack, double Armor) {
        stack.func_196082_o().func_74780_a("iceArmor", Armor);
    }

    public void setChaosArmor(ItemStack stack, double Armor) {
        stack.func_196082_o().func_74780_a("chaosArmor", Armor);
    }

    public void addPhysicalArmor(ItemStack stack, double value, int type) {
        if (type == 0) {
            stack.func_196082_o().func_74780_a("physicalArmorInc+", value);
            stack.func_77978_p().func_74757_a("secondModifier", true);
        }
        if (type == 1) {
            stack.func_196082_o().func_74780_a("physicalArmorInc&", value);
            stack.func_196082_o().func_74757_a("secondModifier", true);
        }
    }

    public void addFireArmor(ItemStack stack, double value, int type) {
        if (type == 0) {
            stack.func_196082_o().func_74780_a("fireArmorInc+", value);
            stack.func_196082_o().func_74757_a("secondModifier", true);
        }
        if (type == 1) {
            stack.func_196082_o().func_74780_a("fireArmorInc&", value);
            stack.func_196082_o().func_74757_a("secondModifier", true);
        }
    }

    public void addIceArmor(ItemStack stack, double value, int type) {
        if (type == 0) {
            stack.func_196082_o().func_74780_a("iceArmorInc+", value);
            stack.func_196082_o().func_74757_a("secondModifier", true);
        }
        if (type == 1) {
            stack.func_196082_o().func_74780_a("iceArmorInc&", value);
            stack.func_196082_o().func_74757_a("secondModifier", true);
        }
    }

    public void addChaosArmor(ItemStack stack, double value, int type) {
        if (type == 0) {
            stack.func_196082_o().func_74780_a("chaosArmorInc+", value);
            stack.func_196082_o().func_74757_a("secondModifier", true);
        }
        if (type == 1) {
            stack.func_196082_o().func_74780_a("chaosArmorInc&", value);
            stack.func_196082_o().func_74757_a("secondModifier", true);
        }
    }

    public void addHP(ItemStack stack, double value, int type) {
        if (type == 0) {
            stack.func_196082_o().func_74780_a("hpInc+", value);
            stack.func_196082_o().func_74757_a("secondModifier", true);
        }
        if (type == 1) {
            stack.func_196082_o().func_74780_a("hpInc&", value);
            stack.func_196082_o().func_74757_a("secondModifier", true);
        }
    }

    public void setCustomName(ItemStack stack) {
        String tierColor_ = "";
        if (this.getTier(stack) == 1) {
            tierColor_ = "\u00a77";
        }
        if (this.getTier(stack) == 2) {
            tierColor_ = "\u00a7a";
        }
        if (this.getTier(stack) == 3) {
            tierColor_ = "\u00a71";
        }
        if (this.getTier(stack) == 4) {
            tierColor_ = "\u00a7d";
        }
        if (this.getTier(stack) == 5) {
            tierColor_ = "\u00a76";
        }
        String suffix_ = "";
        String prefix_ = "";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fireArmor")) {
            suffix_ = " of Fire";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("iceArmor")) {
            suffix_ = " of Ice";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("chaosArmor")) {
            suffix_ = " of Chaos";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("strength")) {
            prefix_ = "Strong ";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("dexterity")) {
            prefix_ = "Swift ";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("intelligence")) {
            prefix_ = "Wise ";
        }
        String firstprefix_ = "";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("mana")) {
            firstprefix_ = "Magical ";
        }
        String baseName_ = stack.func_200301_q().getString();
        stack.func_77978_p().func_74778_a("uncoloredName", prefix_ + firstprefix_ + baseName_ + suffix_);
        stack.func_77978_p().func_74778_a("tierColor", tierColor_);
        stack.func_200302_a((ITextComponent)new StringTextComponent(tierColor_ + prefix_ + firstprefix_ + baseName_ + suffix_));
    }

    public void addCustomModifiers(ItemStack stack) {
        int i;
        this.setPhysicalArmor(stack, (double)new Random().nextInt(7) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
        if (new Random().nextInt(100) + 1 < 20) {
            if (new Random().nextInt(2) + 1 == 1) {
                this.addPhysicalArmor(stack, (double)new Random().nextInt(4) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
            } else {
                this.addPhysicalArmor(stack, (double)(new Random().nextInt(16) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
            }
        }
        if (new Random().nextInt(100) + 1 < 60) {
            this.setEvasion(stack, (double)new Random().nextInt(22) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)(this.getLevel(stack) * 2));
            if (new Random().nextInt(100) + 1 < 20) {
                if (new Random().nextInt(2) + 1 == 1) {
                    this.addEvasion(stack, (double)new Random().nextInt(14) + 1.0 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * 2.0 * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 2.0, 0);
                } else {
                    this.addEvasion(stack, (double)(new Random().nextInt(25) + 14) + 0.75 + (double)(this.getTier(stack) / 4), 1);
                }
            }
        }
        if (new Random().nextInt(2) + 1 == 1) {
            i = new Random().nextInt(3) + 1;
            if (i == 1) {
                this.setFireArmor(stack, (double)new Random().nextInt(5) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
                if (new Random().nextInt(100) + 1 < 20) {
                    if (new Random().nextInt(2) + 1 == 1) {
                        this.addFireArmor(stack, (double)new Random().nextInt(3) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
                    } else {
                        this.addFireArmor(stack, (double)(new Random().nextInt(14) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
                    }
                }
            } else if (i == 2) {
                this.setIceArmor(stack, (double)new Random().nextInt(5) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
                if (new Random().nextInt(100) + 1 < 20) {
                    if (new Random().nextInt(2) + 1 == 1) {
                        this.addIceArmor(stack, (double)new Random().nextInt(3) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
                    } else {
                        this.addIceArmor(stack, (double)(new Random().nextInt(14) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
                    }
                }
            } else if (i == 3) {
                this.setChaosArmor(stack, (double)new Random().nextInt(3) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
                if (new Random().nextInt(100) + 1 < 20) {
                    if (new Random().nextInt(2) + 1 == 1) {
                        this.addChaosArmor(stack, (double)new Random().nextInt(2) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
                    } else {
                        this.addChaosArmor(stack, (double)(new Random().nextInt(12) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
                    }
                }
            }
        }
        if (new Random().nextInt(2) + 1 == 1) {
            i = new Random().nextInt(3) + 1;
            if (i == 1 && new Random().nextInt(100) + 1 < 45 && new Random().nextInt(2) + 1 == 1) {
                this.addDexterity(stack, (double)new Random().nextInt(3) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 10.0);
            }
            if (i == 2 && new Random().nextInt(100) + 1 < 45 && new Random().nextInt(2) + 1 == 1) {
                this.addStrength(stack, (double)new Random().nextInt(3) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 10.0);
            }
            if (i == 3 && new Random().nextInt(100) + 1 < 45 && new Random().nextInt(2) + 1 == 1) {
                this.addIntelligence(stack, (double)new Random().nextInt(3) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 10.0);
            }
        }
        if (new Random().nextInt(2) + 1 == 1 && new Random().nextInt(100) + 1 < 10 && new Random().nextInt(2) + 1 == 1) {
            this.addMana(stack, (double)new Random().nextInt(5) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 10.0);
        }
        this.setHP(stack, (double)new Random().nextInt(7) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
        if (new Random().nextInt(100) + 1 < 20) {
            if (new Random().nextInt(2) + 1 == 1) {
                this.addHP(stack, (double)new Random().nextInt(4) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
            } else {
                this.addHP(stack, (double)(new Random().nextInt(16) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
            }
        }
    }

    public void drop(ItemStack stack, Entity entity, World world) {
        ItemEntity ie = new ItemEntity(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack);
        world.func_217376_c((Entity)ie);
        ie.func_200203_b(stack.func_200301_q());
        ie.func_174805_g(true);
    }
}

