/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.handlers;

import com.icarusfell.diabloloot.lists.ItemList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class CustomPotionHandler {
    public ItemStack createPotion(int type) {
        return new ItemStack((IItemProvider)(type == 0 ? ItemList.health_potion : ItemList.mana_potion));
    }

    public ItemStack createPotionRandom() {
        return new ItemStack((IItemProvider)(new Random().nextInt(2) + 1 == 1 ? ItemList.health_potion : ItemList.mana_potion));
    }

    public void setCreated(ItemStack stack) {
        stack.func_196082_o().func_74757_a("alreadyCreated", true);
    }

    public void setRandomTier(ItemStack stack, int commonchance, int uncommonchance, int magicchance) {
        if (new Random().nextInt(100) + 1 < commonchance) {
            stack.func_196082_o().func_74778_a("potionTier", "Lesser");
        } else if (new Random().nextInt(100) + 1 < uncommonchance) {
            stack.func_196082_o().func_74778_a("potionTier", "Normal");
        } else if (new Random().nextInt(100) + 1 < magicchance) {
            stack.func_196082_o().func_74778_a("potionTier", "Greater");
        } else {
            stack.func_196082_o().func_74778_a("potionTier", "Lesser");
        }
    }

    public String getPotionTier(ItemStack stack) {
        return stack.func_196082_o().func_74779_i("potionTier");
    }

    public String getPotionTierColor(ItemStack stack) {
        String tier = this.getPotionTier(stack);
        String color = "";
        if (tier.contains("Lesser")) {
            color = "\u00a73";
        }
        if (tier.contains("Normal")) {
            color = "\u00a79";
        }
        if (tier.contains("Greater")) {
            color = "\u00a75";
        }
        return color;
    }

    public void setTexture(ItemStack stack) {
        String tier = stack.func_196082_o().func_74779_i("potionTier");
        if (tier.contains("Lesser")) {
            stack.func_196082_o().func_74768_a("potionTexture", 1);
        }
        if (tier.contains("Normal")) {
            stack.func_196082_o().func_74768_a("potionTexture", 2);
        }
        if (tier.contains("Greater")) {
            stack.func_196082_o().func_74768_a("potionTexture", 3);
        }
    }

    public void setCustomName(ItemStack stack) {
        boolean shouldRename = false;
        boolean bl = shouldRename = !this.getPotionTier(stack).contains("Normal");
        if (shouldRename) {
            String baseName = stack.func_200301_q().getString();
            String tier = this.getPotionTier(stack);
            String tierColor = this.getPotionTierColor(stack);
            stack.func_200302_a((ITextComponent)new StringTextComponent(tierColor + tier + " " + baseName));
        } else {
            String baseName = stack.func_200301_q().getString();
            String tierColor = this.getPotionTierColor(stack);
            stack.func_200302_a((ITextComponent)new StringTextComponent(tierColor + baseName));
        }
    }

    public void create(ItemStack stack) {
        this.setCreated(stack);
        this.setRandomTier(stack, 60, 60, 60);
        this.setTexture(stack);
        this.setCustomName(stack);
    }

    public void drop(ItemStack stack, Entity entity, World world) {
        ItemEntity ie = new ItemEntity(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack);
        world.func_217376_c((Entity)ie);
        ie.func_200203_b(stack.func_151000_E());
        ie.func_174805_g(true);
    }
}

