/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.handlers;

import com.icarusfell.diabloloot.config.Common;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class MethodHandler {
    public static <T extends Entity> List<T> getEntitiesInRadius(Class<T> entityClass, Entity entity, int radius) {
        List listOfT = entity.field_70170_p.func_217357_a(entityClass, new AxisAlignedBB(entity.func_226277_ct_() - (double)radius, entity.func_226278_cu_() - (double)radius, entity.func_226281_cx_() - (double)radius, entity.func_226277_ct_() + (double)radius, entity.func_226278_cu_() + (double)radius, entity.func_226281_cx_() + (double)radius));
        return listOfT;
    }

    public static ItemEntity entityDropItem(ItemStack stack, Entity entity) {
        return entity.func_70099_a(stack, 0.0f);
    }

    public static void drop(ItemStack stack, Entity entity, World world) {
        ItemEntity ie = new ItemEntity(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack);
        world.func_217376_c((Entity)ie);
        ie.func_200203_b(stack.func_151000_E());
        ie.func_174805_g(true);
    }

    public static ResourceLocation getLootTableResourceLocation(Entity entity) {
        return entity instanceof SheepEntity ? ((SheepEntity)entity).func_213346_cF() : entity.func_200600_R().func_220348_g();
    }

    public static void dropLoot(Entity entity) {
        if (((Boolean)Common.vanillaMobDrops.get()).booleanValue()) {
            ResourceLocation resourcelocation = MethodHandler.getLootTableResourceLocation(entity);
            LootTable loottable = entity.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
            LootContext.Builder lootcontext$builder = MethodHandler.getLootContextBuilder(entity);
            LootContext ctx = lootcontext$builder.func_216022_a(LootParameterSets.field_216263_d);
            loottable.func_216113_a(ctx).forEach(itemStack -> MethodHandler.entityDropItem(itemStack, entity));
        }
    }

    public static LootContext.Builder getLootContextBuilder(Entity entity) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)entity.field_70170_p).func_216023_a(new Random()).func_216015_a(LootParameters.field_216281_a, (Object)entity).func_216015_a(LootParameters.field_237457_g_, (Object)entity.func_213303_ch()).func_216015_a(LootParameters.field_216283_c, (Object)DamageSource.field_76377_j);
        return lootcontext$builder;
    }

    public static void dropExperience(Entity entity, int amount) {
        if (((Boolean)Common.vanillaMobDrops.get()).booleanValue()) {
            int j = ExperienceOrbEntity.func_70527_a((int)amount);
            entity.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), j));
        }
    }

    public static double getDistanceTo(Entity entity, BlockPos pos) {
        double deltaX = Math.abs(entity.func_226277_ct_() - (double)pos.func_177958_n());
        double deltaY = Math.abs(entity.func_226278_cu_() - (double)pos.func_177956_o());
        double deltaZ = Math.abs(entity.func_226281_cx_() - (double)pos.func_177952_p());
        return Math.cbrt(deltaX * deltaX * deltaX + deltaY * deltaY * deltaY + deltaZ * deltaZ * deltaZ);
    }

    public static double getDistanceTo(BlockPos posa, BlockPos posb) {
        double deltaX = Math.abs(posa.func_177958_n() - posb.func_177958_n());
        double deltaY = Math.abs(posa.func_177956_o() - posb.func_177956_o());
        double deltaZ = Math.abs(posa.func_177952_p() - posb.func_177952_p());
        return Math.cbrt(deltaX * deltaX * deltaX + deltaY * deltaY * deltaY + deltaZ * deltaZ * deltaZ);
    }

    public static double getDistanceTo(Entity entitya, Entity entityb) {
        double deltaX = Math.abs(entitya.func_226277_ct_() - entityb.func_226277_ct_());
        double deltaY = Math.abs(entitya.func_226278_cu_() - entityb.func_226278_cu_());
        double deltaZ = Math.abs(entitya.func_226281_cx_() - entityb.func_226281_cx_());
        return Math.cbrt(deltaX * deltaX * deltaX + deltaY * deltaY * deltaY + deltaZ * deltaZ * deltaZ);
    }

    public static List<Item> getItemsFromString(String[] inputs) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (String input : inputs) {
            ResourceLocation itemLocation;
            Item item;
            String[] parts = input.split(":");
            if (parts.length <= 0) continue;
            if (parts[0].equalsIgnoreCase("tag") && parts.length == 3) {
                List itemList;
                ResourceLocation tagLocation = new ResourceLocation(parts[1], parts[2]);
                Tag tagContents = (Tag)ItemTags.func_199903_a().func_199910_a(tagLocation);
                if (tagContents == null || (itemList = tagContents.func_230236_b_()).isEmpty()) continue;
                for (Item item2 : itemList) {
                    items.add(item2);
                }
                continue;
            }
            if (parts.length <= 1 || (item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation = new ResourceLocation(parts[0], parts[1]))) == null) continue;
            items.add(item);
        }
        return items;
    }

    public static Item getItemFromString(String input) {
        Item items = null;
        String[] parts = input.split(":");
        if (parts.length > 0) {
            ResourceLocation itemLocation;
            Item item;
            if (parts[0].equalsIgnoreCase("tag") && parts.length == 3) {
                List itemList;
                ResourceLocation tagLocation = new ResourceLocation(parts[1], parts[2]);
                Tag tagContents = (Tag)ItemTags.func_199903_a().func_199910_a(tagLocation);
                if (tagContents != null && !(itemList = tagContents.func_230236_b_()).isEmpty()) {
                    Iterator iterator = itemList.iterator();
                    while (iterator.hasNext()) {
                        Item item2;
                        items = item2 = (Item)iterator.next();
                    }
                }
            } else if (parts.length > 1 && (item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation = new ResourceLocation(parts[0], parts[1]))) != null) {
                items = item;
            }
        }
        return items;
    }

    public static List<EntityType<?>> getEntityTypesFromString(String[] inputs) {
        ArrayList entityTypes = new ArrayList();
        for (String input : inputs) {
            ResourceLocation itemLocation;
            EntityType entityType;
            String[] parts = input.split(":");
            if (parts.length <= 0 || parts.length <= 1 || (entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(itemLocation = new ResourceLocation(parts[0], parts[1]))) == null) continue;
            entityTypes.add(entityType);
        }
        return entityTypes;
    }

    public static EntityType<?> getEntityTypeFromString(String input) {
        ResourceLocation itemLocation;
        EntityType entity;
        EntityType entities = null;
        String[] parts = input.split(":");
        if (parts.length > 0 && parts.length > 1 && (entity = (EntityType)ForgeRegistries.ENTITIES.getValue(itemLocation = new ResourceLocation(parts[0], parts[1]))) != null) {
            entities = entity;
        }
        return entities;
    }

    public static int getModifierValueFromString(String input) {
        int value = 0;
        String[] parts = input.split(":");
        if (parts.length > 1) {
            value = Integer.parseInt(parts[1]);
        }
        return value;
    }

    public static int getMinLevelFromString(String input) {
        String[] parts = input.split(":");
        String values = parts[2];
        String[] valueParts = values.split("-");
        return Integer.parseInt(valueParts[0]);
    }

    public static int getMaxLevelFromString(String input) {
        String[] parts = input.split(":");
        String values = parts[2];
        String[] valueParts = values.split("-");
        return Integer.parseInt(valueParts[1]);
    }

    public static void dropItem(ItemStack stack, BlockPos pos, World world) {
        ItemEntity ie = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        world.func_217376_c((Entity)ie);
        ie.func_200203_b(stack.func_151000_E());
        ie.func_174805_g(true);
    }

    public static double getInheritedMaxHealth(PlayerEntity player) {
        return player.getPersistentData().func_74760_g("diablolootinheritedMaxHealth");
    }

    public static void setInheritedMaxHealth(PlayerEntity player, double value) {
        player.getPersistentData().func_74780_a("diablolootinheritedMaxHealth", value);
    }

    public static int getInheritedTier(PlayerEntity player) {
        return player.getPersistentData().func_74762_e("diablolootinheritedTier");
    }

    public static void setInheritedTier(PlayerEntity player, int value) {
        player.getPersistentData().func_74768_a("diablolootinheritedTier", value);
    }

    public static int getTier(Entity entity) {
        return entity.getPersistentData().func_74762_e("diablolootlevel");
    }

    public static double getInheritedDefaultHealth(PlayerEntity player) {
        return player.getPersistentData().func_74760_g("diablolootinheritedDefaultHealth");
    }

    public static void setInheritedDefaultHealth(PlayerEntity player, double value) {
        player.getPersistentData().func_74780_a("diablolootinheritedDefaultHealth", value);
    }

    public static String getInheritedName(PlayerEntity player) {
        return player.getPersistentData().func_74779_i("diablolootinheritedString");
    }

    public static void setInheritedName(PlayerEntity player, String value) {
        player.getPersistentData().func_74778_a("diablolootinheritedString", value);
    }

    public static boolean isBossbarOn(PlayerEntity player) {
        return player.getPersistentData().func_74767_n("diablolootbossbarOn");
    }

    public static void setBossbar(PlayerEntity player, boolean flag) {
        player.getPersistentData().func_74757_a("diablolootbossbarOn", flag);
    }

    public static boolean isUndefeatable(Entity entity) {
        return entity.getPersistentData().func_74767_n("diablolootisSlayer");
    }
}

