/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.handlers;

import com.icarusfell.diabloloot.Main;
import com.icarusfell.diabloloot.handlers.MethodHandler;
import com.icarusfell.diabloloot.handlers.MobDropsHandler;
import com.icarusfell.diabloloot.network.Networking;
import com.icarusfell.diabloloot.network.SendParticles;
import com.icarusfell.diabloloot.network.SyncBossBar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class SlayerHandler {
    public static void updateSlayerKills(PlayerEntity player, Entity target) {
        if (player.getPersistentData().func_74767_n("diablolootonHunt")) {
            if (player.getPersistentData().func_74762_e("diabloloothuntLevel") <= target.getPersistentData().func_74762_e("diablolootlevel")) {
                player.getPersistentData().func_74768_a("diablolootkills", player.getPersistentData().func_74762_e("diablolootkills") + 1);
            }
            if (player.getPersistentData().func_74762_e("diablolootkills") >= player.getPersistentData().func_74762_e("diablolootkillsRequired")) {
                player.getPersistentData().func_74768_a("diablolootkills", player.getPersistentData().func_74762_e("diablolootkillsRequired"));
                if (!player.getPersistentData().func_74767_n("diablolootslayerSpawned")) {
                    player.getPersistentData().func_74757_a("diablolootslayerSpawned", true);
                    SlayerHandler.spawnSlayer(player, target);
                }
            }
        }
    }

    public static void spawnSlayer(PlayerEntity player, Entity target) {
        List<PlayerEntity> list = MethodHandler.getEntitiesInRadius(PlayerEntity.class, (Entity)player, 60);
        list.forEach(pl -> Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)pl), (Object)new SendParticles(target.func_226277_ct_(), target.func_226278_cu_() - 1.0, target.func_226281_cx_(), 4.0f, 4.0f, 11)));
        String str = player.getPersistentData().func_74779_i("diabloloothuntMobType");
        EntityType entityType = null;
        for (EntityType type : ForgeRegistries.ENTITIES) {
            if (!type.toString().contentEquals(str)) continue;
            entityType = type;
        }
        Entity slayer = entityType.func_200721_a(player.field_70170_p);
        int level = player.getPersistentData().func_74762_e("diabloloothuntLevel");
        int health = player.getPersistentData().func_74762_e("diabloloothuntHealth");
        int physicalDamage = player.getPersistentData().func_74762_e("diabloloothuntPhysicalDamage");
        int fireDamage = player.getPersistentData().func_74762_e("diabloloothuntFireDamage");
        int chaosDamage = player.getPersistentData().func_74762_e("diabloloothuntChaosDamage");
        int iceDamage = player.getPersistentData().func_74762_e("diabloloothuntIceDamage");
        int physicalArmor = player.getPersistentData().func_74762_e("diabloloothuntPhysicalArmor");
        int fireArmor = player.getPersistentData().func_74762_e("diabloloothuntFireArmor");
        int chaosArmor = player.getPersistentData().func_74762_e("diabloloothuntChaosArmor");
        int iceArmor = player.getPersistentData().func_74762_e("diabloloothuntIceArmor");
        String name = player.getPersistentData().func_74779_i("diabloloothuntName");
        boolean leaping = player.getPersistentData().func_74767_n("diablolootleaping");
        boolean smacking = player.getPersistentData().func_74767_n("diablolootsmacking");
        boolean thrusting = player.getPersistentData().func_74767_n("diablolootthrusting");
        boolean dodging = player.getPersistentData().func_74767_n("diablolootdodging");
        boolean dashing = player.getPersistentData().func_74767_n("diablolootsmacking");
        String id = player.getPersistentData().func_74779_i("diabloloothuntId");
        slayer.getPersistentData().func_74757_a("diablolootisSlayer", true);
        slayer.getPersistentData().func_74757_a("diablolootdlmob", true);
        slayer.getPersistentData().func_74768_a("diablolootlevel", level);
        slayer.getPersistentData().func_74778_a("diablolootsummoner", player.func_189512_bd());
        slayer.getPersistentData().func_74780_a("diablolootmaxHealth", (double)health);
        slayer.getPersistentData().func_74780_a("diablolootdefaultHealth", (double)health);
        slayer.getPersistentData().func_74780_a("diablolootdamage", (double)(physicalDamage * 2));
        slayer.getPersistentData().func_74780_a("diablolootphysicalArmor", (double)physicalArmor);
        slayer.getPersistentData().func_74780_a("diablolootfireArmor", (double)fireArmor);
        slayer.getPersistentData().func_74780_a("diablolooticeArmor", (double)iceArmor);
        slayer.getPersistentData().func_74780_a("diablolootchaosArmor", (double)chaosArmor);
        slayer.getPersistentData().func_74780_a("diablolootfireDamage", (double)fireDamage);
        slayer.getPersistentData().func_74780_a("diablolooticeDamage", (double)iceDamage);
        slayer.getPersistentData().func_74780_a("diablolootchaosDamage", (double)chaosDamage);
        slayer.getPersistentData().func_74780_a("diablolootexpdrop", (double)(18 + level * 500));
        slayer.getPersistentData().func_74757_a("diabloloothasFire", true);
        slayer.getPersistentData().func_74757_a("diabloloothasIce", true);
        slayer.getPersistentData().func_74757_a("diabloloothasChaos", true);
        slayer.getPersistentData().func_74778_a("diablolootdefaultName", name);
        slayer.getPersistentData().func_74778_a("diablolootname", "Level " + level + " " + name);
        slayer.getPersistentData().func_74757_a("diablolootleaping", leaping);
        slayer.getPersistentData().func_74757_a("diablolootsmacking", smacking);
        slayer.getPersistentData().func_74757_a("diablolootthrusting", thrusting);
        slayer.getPersistentData().func_74757_a("diablolootdodging", dodging);
        slayer.getPersistentData().func_74757_a("diablolootdashing", dashing);
        slayer.getPersistentData().func_74778_a("diablolootid", id);
        slayer.getPersistentData().func_74774_a("IsImmuneToZombification", (byte)1);
        slayer.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)MethodHandler.getItemFromString(player.getPersistentData().func_74779_i("diabloloothuntMainhand"))));
        slayer.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)MethodHandler.getItemFromString(player.getPersistentData().func_74779_i("diabloloothuntOffhand"))));
        slayer.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)MethodHandler.getItemFromString(player.getPersistentData().func_74779_i("diabloloothuntHelmet"))));
        slayer.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)MethodHandler.getItemFromString(player.getPersistentData().func_74779_i("diabloloothuntChestplate"))));
        slayer.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)MethodHandler.getItemFromString(player.getPersistentData().func_74779_i("diabloloothuntLeggings"))));
        slayer.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)MethodHandler.getItemFromString(player.getPersistentData().func_74779_i("diabloloothuntBoots"))));
        player.field_70170_p.func_217376_c(slayer);
        slayer.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        slayer.func_200203_b((ITextComponent)new StringTextComponent("\u00a7cLevel " + level + " " + name));
        slayer.func_174805_g(true);
    }

    public static void onSlayerDeath(PlayerEntity player, Entity entity) {
        if (entity.getPersistentData().func_74767_n("diablolootisSlayer")) {
            Main.dropsHandler.bossDeath(entity);
            MobDropsHandler.slayerUniqueDeath(entity);
            SlayerHandler.refreshData(entity.field_70170_p.func_217371_b(UUID.fromString(entity.getPersistentData().func_74779_i("diablolootsummoner"))));
        }
    }

    public static void slayerAttack(Entity entity1, Entity entity2) {
        if (entity1.getPersistentData().func_74767_n("diablolootleaping") && new Random().nextInt(100) + 1 <= 40) {
            entity1.func_226286_f_(entity2.func_226277_ct_(), entity2.func_226278_cu_() + 2.0, entity2.func_226281_cx_());
        }
        if (entity1.getPersistentData().func_74767_n("diablolootsmacking") && new Random().nextInt(100) + 1 <= 40) {
            Vector3d lookVec = entity1.func_70040_Z();
            double x = lookVec.field_72450_a;
            double y = lookVec.field_72448_b;
            double z = lookVec.field_72449_c;
            entity2.func_213293_j(x * -3.0, y * 2.0, z * -3.0);
        }
        if (entity1.getPersistentData().func_74767_n("diablolootthrusting")) {
            entity2.func_213293_j(0.0, 0.8, 0.0);
        }
    }

    public static void slayerHurt(PlayerEntity player, Entity entity) {
        if (entity.getPersistentData().func_74767_n("diablolootdodging") && new Random().nextInt(3) + 1 == 2) {
            entity.func_213293_j(player.func_70040_Z().field_72450_a * 2.5, player.func_70040_Z().field_72448_b * 2.0, player.func_70040_Z().field_72449_c * 2.5);
        }
    }

    public static void slayerTick(Entity entity) {
        if (entity.getPersistentData().func_74767_n("diablolootdashing") && new Random().nextInt(300) == 5) {
            entity.func_213293_j(entity.func_70040_Z().field_72450_a * 2.5, entity.func_70040_Z().field_72448_b * 2.0, entity.func_70040_Z().field_72449_c * 2.5);
        }
    }

    public static void refreshData(PlayerEntity player) {
        player.getPersistentData().func_74757_a("diablolootonHunt", false);
        player.getPersistentData().func_74757_a("diablolootslayerSpawned", false);
        player.getPersistentData().func_74768_a("diabloloothuntHealth", 0);
        player.getPersistentData().func_74768_a("diabloloothuntLevel", 0);
        player.getPersistentData().func_74768_a("diabloloothuntPhysicalArmor", 0);
        player.getPersistentData().func_74768_a("diabloloothuntIceArmor", 0);
        player.getPersistentData().func_74768_a("diabloloothuntFireArmor", 0);
        player.getPersistentData().func_74768_a("diabloloothuntChaosArmor", 0);
        player.getPersistentData().func_74768_a("diabloloothuntPhysicalDamage", 0);
        player.getPersistentData().func_74768_a("diabloloothuntIceDamage", 0);
        player.getPersistentData().func_74768_a("diabloloothuntFireDamage", 0);
        player.getPersistentData().func_74768_a("diabloloothuntChaosDamage", 0);
        player.getPersistentData().func_74757_a("diablolootleaping", false);
        player.getPersistentData().func_74757_a("diablolootsmacking", false);
        player.getPersistentData().func_74757_a("diablolootthrusting", false);
        player.getPersistentData().func_74757_a("diablolootdodging", false);
        player.getPersistentData().func_74757_a("diablolootdashing", false);
        player.getPersistentData().func_74768_a("diablolootkills", 0);
        player.getPersistentData().func_74768_a("diablolootkillsRequired", 0);
        player.getPersistentData().func_74778_a("diabloloothuntMobType", "");
        player.getPersistentData().func_74778_a("diabloloothuntName", "");
        player.getPersistentData().func_74778_a("diabloloothuntId", "");
    }

    @SubscribeEvent
    public void searchMobsAndApply(TickEvent.PlayerTickEvent e) {
        if (!e.player.field_70170_p.field_72995_K) {
            PlayerEntity player = e.player;
            ArrayList<Entity> undefeatableList = new ArrayList<Entity>();
            List<Entity> entityList = MethodHandler.getEntitiesInRadius(Entity.class, (Entity)player, 30);
            HashMap<Entity, Integer> entityMap = new HashMap<Entity, Integer>();
            for (Entity en : entityList) {
                if (!MethodHandler.isUndefeatable(en)) continue;
                undefeatableList.add(en);
            }
            if (undefeatableList.isEmpty()) {
                MethodHandler.setBossbar(player, false);
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SyncBossBar(MethodHandler.getInheritedDefaultHealth(player), MethodHandler.getInheritedMaxHealth(player), MethodHandler.getInheritedTier(player), MethodHandler.isBossbarOn(player), MethodHandler.getInheritedName(player)));
                return;
            }
            MethodHandler.setBossbar(player, true);
            for (Entity en : undefeatableList) {
                int distance = (int)MethodHandler.getDistanceTo(en, (Entity)player);
                entityMap.put(en, distance);
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SendParticles(en.func_226277_ct_(), en.func_226278_cu_() - 1.0, en.func_226281_cx_(), en.func_213302_cg(), en.func_213311_cf(), 12));
            }
            Map.Entry min = null;
            for (Map.Entry entry : entityMap.entrySet()) {
                if (min != null && (Integer)min.getValue() <= (Integer)entry.getValue()) continue;
                min = entry;
            }
            if (MethodHandler.getInheritedDefaultHealth(player) != ((LivingEntity)min.getKey()).getPersistentData().func_74769_h("diablolootdefaultHealth")) {
                MethodHandler.setInheritedDefaultHealth(player, ((LivingEntity)min.getKey()).getPersistentData().func_74769_h("diablolootdefaultHealth"));
            }
            if (MethodHandler.getInheritedMaxHealth(player) != ((LivingEntity)min.getKey()).getPersistentData().func_74769_h("diablolootmaxHealth")) {
                MethodHandler.setInheritedMaxHealth(player, ((LivingEntity)min.getKey()).getPersistentData().func_74769_h("diablolootmaxHealth"));
            }
            if (MethodHandler.getInheritedTier(player) != MethodHandler.getTier((Entity)min.getKey())) {
                MethodHandler.setInheritedTier(player, MethodHandler.getTier((Entity)min.getKey()));
            }
            if (!MethodHandler.getInheritedName(player).contains(((Entity)min.getKey()).getPersistentData().func_74779_i("diablolootdefaultName"))) {
                MethodHandler.setInheritedName(player, ((Entity)min.getKey()).getPersistentData().func_74779_i("diablolootdefaultName"));
            }
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SyncBossBar(MethodHandler.getInheritedDefaultHealth(player), MethodHandler.getInheritedMaxHealth(player), MethodHandler.getInheritedTier(player), MethodHandler.isBossbarOn(player), MethodHandler.getInheritedName(player)));
        }
    }
}

