/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.network;

import com.icarusfell.diabloloot.items.SlayerBook;
import com.icarusfell.diabloloot.slayerconfig.SlayerEntry;
import com.icarusfell.diabloloot.slayerconfig.SlayerScreenBuilder;
import com.icarusfell.diabloloot.slayergui.SlayerScreen;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SlayerEntryPacket {
    public String id;
    public int pageId;
    public boolean lastPage;
    public String entityType;
    public int entitySize;
    public String entityName;
    public int entityNameHexColor;
    public String entityMainhand;
    public String entityOffhand;
    public String entityHead;
    public String entityChestplate;
    public String entityLeggings;
    public String entityBoots;
    public boolean hasLevel;
    public int level;
    public boolean hasHealth;
    public int health;
    public boolean hasPhysicalArmor;
    public int physicalArmor;
    public boolean hasIceArmor;
    public int iceArmor;
    public boolean hasFireArmor;
    public int fireArmor;
    public boolean hasChaosArmor;
    public int chaosArmor;
    public boolean hasPhysicalDamage;
    public int physicalDamage;
    public boolean hasIceDamage;
    public int iceDamage;
    public boolean hasFireDamage;
    public int fireDamage;
    public boolean hasChaosDamage;
    public int chaosDamage;
    public boolean isLeaping;
    public boolean isSmacking;
    public boolean isThrusting;
    public boolean isDodging;
    public boolean isDashing;

    public SlayerEntryPacket(PacketBuffer buf) {
        this.id = buf.func_150789_c(Short.MAX_VALUE);
        this.pageId = buf.readInt();
        this.lastPage = buf.readBoolean();
        this.entityType = buf.func_150789_c(Short.MAX_VALUE);
        this.entitySize = buf.readInt();
        this.entityName = buf.func_150789_c(Short.MAX_VALUE);
        this.entityNameHexColor = buf.readInt();
        this.entityMainhand = buf.func_150789_c(Short.MAX_VALUE);
        this.entityOffhand = buf.func_150789_c(Short.MAX_VALUE);
        this.entityHead = buf.func_150789_c(Short.MAX_VALUE);
        this.entityChestplate = buf.func_150789_c(Short.MAX_VALUE);
        this.entityLeggings = buf.func_150789_c(Short.MAX_VALUE);
        this.entityBoots = buf.func_150789_c(Short.MAX_VALUE);
        this.hasLevel = buf.readBoolean();
        this.level = buf.readInt();
        this.hasHealth = buf.readBoolean();
        this.health = buf.readInt();
        this.hasPhysicalArmor = buf.readBoolean();
        this.physicalArmor = buf.readInt();
        this.hasIceArmor = buf.readBoolean();
        this.iceArmor = buf.readInt();
        this.hasFireArmor = buf.readBoolean();
        this.fireArmor = buf.readInt();
        this.hasChaosArmor = buf.readBoolean();
        this.chaosArmor = buf.readInt();
        this.hasPhysicalDamage = buf.readBoolean();
        this.physicalDamage = buf.readInt();
        this.hasIceDamage = buf.readBoolean();
        this.iceDamage = buf.readInt();
        this.hasFireDamage = buf.readBoolean();
        this.fireDamage = buf.readInt();
        this.hasChaosDamage = buf.readBoolean();
        this.chaosDamage = buf.readInt();
        this.isLeaping = buf.readBoolean();
        this.isSmacking = buf.readBoolean();
        this.isThrusting = buf.readBoolean();
        this.isDodging = buf.readBoolean();
        this.isDashing = buf.readBoolean();
    }

    public SlayerEntryPacket(String id, int pageId, boolean lastPage, String entityType, int entitySize, String entityName, int entityNameHexColor, String entityMainhand, String entityOffhand, String entityHead, String entityChestplate, String entityLeggings, String entityBoots, boolean hasLevel, int level, boolean hasHealth, int health, boolean hasPhysicalArmor, int physicalArmor, boolean hasIceArmor, int iceArmor, boolean hasFireArmor, int fireArmor, boolean hasChaosArmor, int chaosArmor, boolean hasPhysicalDamage, int physicalDamage, boolean hasIceDamage, int iceDamage, boolean hasFireDamage, int fireDamage, boolean hasChaosDamage, int chaosDamage, boolean isLeaping, boolean isSmacking, boolean isThrusting, boolean isDodging, boolean isDashing) {
        this.id = id;
        this.pageId = pageId;
        this.lastPage = lastPage;
        this.entityType = entityType;
        this.entitySize = entitySize;
        this.entityName = entityName;
        this.entityNameHexColor = entityNameHexColor;
        this.entityMainhand = entityMainhand;
        this.entityOffhand = entityOffhand;
        this.entityHead = entityHead;
        this.entityChestplate = entityChestplate;
        this.entityLeggings = entityLeggings;
        this.entityBoots = entityBoots;
        this.hasLevel = hasLevel;
        this.level = level;
        this.hasHealth = hasHealth;
        this.health = health;
        this.hasPhysicalArmor = hasPhysicalArmor;
        this.physicalArmor = physicalArmor;
        this.hasIceArmor = hasIceArmor;
        this.iceArmor = iceArmor;
        this.hasFireArmor = hasFireArmor;
        this.fireArmor = fireArmor;
        this.hasChaosArmor = hasChaosArmor;
        this.chaosArmor = chaosArmor;
        this.hasPhysicalDamage = hasPhysicalDamage;
        this.physicalDamage = physicalDamage;
        this.hasIceDamage = hasIceDamage;
        this.iceDamage = iceDamage;
        this.hasFireDamage = hasFireDamage;
        this.fireDamage = fireDamage;
        this.hasChaosDamage = hasChaosDamage;
        this.chaosDamage = chaosDamage;
        this.isLeaping = isLeaping;
        this.isSmacking = isSmacking;
        this.isThrusting = isThrusting;
        this.isDodging = isDodging;
        this.isDashing = isDashing;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.id);
        buf.writeInt(this.pageId);
        buf.writeBoolean(this.lastPage);
        buf.func_180714_a(this.entityType);
        buf.writeInt(this.entitySize);
        buf.func_180714_a(this.entityName);
        buf.writeInt(this.entityNameHexColor);
        buf.func_180714_a(this.entityMainhand);
        buf.func_180714_a(this.entityOffhand);
        buf.func_180714_a(this.entityHead);
        buf.func_180714_a(this.entityChestplate);
        buf.func_180714_a(this.entityLeggings);
        buf.func_180714_a(this.entityBoots);
        buf.writeBoolean(this.hasLevel);
        buf.writeInt(this.level);
        buf.writeBoolean(this.hasHealth);
        buf.writeInt(this.health);
        buf.writeBoolean(this.hasPhysicalArmor);
        buf.writeInt(this.physicalArmor);
        buf.writeBoolean(this.hasIceArmor);
        buf.writeInt(this.iceArmor);
        buf.writeBoolean(this.hasFireArmor);
        buf.writeInt(this.fireArmor);
        buf.writeBoolean(this.hasChaosArmor);
        buf.writeInt(this.chaosArmor);
        buf.writeBoolean(this.hasPhysicalDamage);
        buf.writeInt(this.physicalDamage);
        buf.writeBoolean(this.hasIceDamage);
        buf.writeInt(this.iceDamage);
        buf.writeBoolean(this.hasFireDamage);
        buf.writeInt(this.fireDamage);
        buf.writeBoolean(this.hasChaosDamage);
        buf.writeInt(this.chaosDamage);
        buf.writeBoolean(this.isLeaping);
        buf.writeBoolean(this.isSmacking);
        buf.writeBoolean(this.isThrusting);
        buf.writeBoolean(this.isDodging);
        buf.writeBoolean(this.isDashing);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient() && ((NetworkEvent.Context)ctx.get()).getDirection().getOriginationSide().isServer()) {
                SlayerEntry entry = new SlayerEntry(this.id, this.pageId, this.lastPage, this.entityType, this.entitySize, this.entityName, this.entityNameHexColor, this.entityMainhand, this.entityOffhand, this.entityHead, this.entityChestplate, this.entityLeggings, this.entityBoots, this.hasLevel, this.level, this.hasHealth, this.health, this.hasPhysicalArmor, this.physicalArmor, this.hasIceArmor, this.iceArmor, this.hasFireArmor, this.fireArmor, this.hasChaosArmor, this.chaosArmor, this.hasPhysicalDamage, this.physicalDamage, this.hasIceDamage, this.iceDamage, this.hasFireDamage, this.fireDamage, this.hasChaosDamage, this.chaosDamage, this.isLeaping, this.isSmacking, this.isThrusting, this.isDodging, this.isDashing);
                SlayerScreen screen = SlayerScreenBuilder.build(entry);
                SlayerBook.serverScreenMap.put(entry.getPageId(), screen);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

